@extends('layouts.app')

@section('title', 'Prévisions')

@section('content')
<div class="pagetitle">
  <h3>Tableau des prévisions</h3>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Prévisions</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <!-- Table with stripped rows -->
			<style>
				/* Tableau avec bordures */
				.table-bordered-custom {
					border: 1px solid #dee2e6;
					border-collapse: collapse;
				}

				.table-bordered-custom th,
				.table-bordered-custom td {
					border: 1px solid #dee2e6;
					vertical-align: middle;
					padding: 0.5rem 0.75rem;
				}

				/* Badge stylé déjà existant */
				.badge {
					display: inline-block;
					padding: 3px 8px;
					border-radius: 5px;
					font-weight: bold;
					font-size: 0.9rem;
				}

				.bg-blue { background-color: #cfe2ff; color: #003366; }
				.bg-yellow { background-color: #fff3cd; color: #856404; }
				.bg-orange { background-color: #ffe5b4; color: #b35c00; }
				.bg-green { background-color: #d4edda; color: #155724; }
				.bg-red { background-color: #f8d7da; color: #721c24; }

				/* Survol des lignes pour améliorer la lisibilité */
				.table-bordered-custom tbody tr:hover {
					background-color: #f1f3f5;
				}
				</style>

				<table class="table table-bordered-custom table-striped">
					<thead class="table-dark">
						<tr>
							<th>Activité</th>
							<th>Extrant</th>
							<th>Date prévisionnelle</th>
							<th>Taux prévisionnel (%)</th>
							<th>État d'évaluation</th>
						</tr>
					</thead>
					<tbody>
						@foreach($previsions->groupBy('activite_id') as $activiteId => $activitePrevisions)
							@php
								$activite = $activitePrevisions->first()->activite;
								$extrantsGrouped = $activitePrevisions->groupBy('extrant_id');
							@endphp
							@foreach($extrantsGrouped as $extrantId => $extrantPrevisions)
								@php
									$extrant = $extrantPrevisions->first()->extrant;
								@endphp
								@foreach($extrantPrevisions as $index => $p)
									@php
										$today = now();
										$dateEval = \Carbon\Carbon::parse($p->dateevaluation);
										$etat = '';
										$style = '';
										$details = '';

										if ($dateEval->isFuture()) {
											$etat = 'À venir';
											$style = 'bg-blue';
										} else {
											if ($p->evaluations->isEmpty()) {
												$jours = $dateEval->diffInDays($today, false);
												$jours = (int) $jours;
												$etat = 'En retard';
												$details = "($jours jrs)";
												$style = 'bg-red';
											} else {
												$evaluation = $p->evaluations->first();
												if (!$evaluation->valide) {
													$etat = 'Évalué non validé';
													$style = 'bg-orange';
												} else {
													$etat = 'Évalué et validé';
													$style = 'bg-green';
												}
											}
										}
									@endphp
									<tr>
										{{-- Activité : seulement sur la première ligne du groupe --}}
										@if($loop->first && $loop->parent->first)
											<td rowspan="{{ $extrantsGrouped->sum(fn($grp) => $grp->count()) }}">
												{{ $activite->nom }}
												<a href="{{ route('activites.planning', $activite->id) }}" class="btn btn-info btn-sm">
													<i class="bi bi-eye"></i>
												</a>
											</td>
										@endif

										{{-- Extrant : seulement sur la première ligne de son groupe --}}
										@if($loop->first)
											<td rowspan="{{ $extrantPrevisions->count() }}">
												{{ $extrant->nom }}
											</td>
										@endif

										{{-- Prévision --}}
										<td>{{ $p->dateevaluation }}</td>
										<td>{{ $p->niveaucible }}</td>
										<td>
											<span class="badge {{ $style }}">
												{{ $etat }} {{ $details }}
											</span>
										</td>
									</tr>
								@endforeach
							@endforeach
						@endforeach
					</tbody>
				</table>

          <!-- End Table -->
        </div>
      </div>

    </div>
  </div>
</section>
@endsection

