@extends('layouts.app')

@section('title', 'Programmes')

@section('content')
<div class="pagetitle">
    <h1>Programmes</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">Programmes</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    @php
                        $usergroupId = Auth::user()->usergroup_id;
                    @endphp

                    @if(in_array($usergroupId , [2, 4]))
                        <h5 class="card-title">
                            <a href="{{ route('programmes.create') }}" class="btn btn-primary rounded-pill">
                                <i class="bi bi-plus-circle"></i> Ajouter
                            </a>
                        </h5>
                    @endif

                    <style>
                        .table-custom {
                            width: 100%;
                            border-collapse: collapse;
                            border: 1px solid #dee2e6;
                        }
                        .table-custom th,
                        .table-custom td {
                            border: 1px solid #dee2e6;
                            padding: 0.5rem 0.75rem;
                            vertical-align: middle;
                        }

                        /* En-tête sombre et centrée */
                        .table-custom thead th {
                            background-color: #343a40;
                            color: #fff;
                            text-align: center;
                            text-transform: uppercase;
                            letter-spacing: 0.5px;
                        }

                        /* Contenu des cellules justifié à gauche */
                        .table-custom tbody td {
                            text-align: left;
                        }

                        /* Lignes alternées et survol */
                        .table-custom tbody tr:nth-child(odd) {
                            background-color: #f8f9fa;
                        }
                        .table-custom tbody tr:hover {
                            background-color: #e9ecef;
                        }

                        /* Boutons stylisés */
                        .btn-sm-status {
                            padding: 0.25rem 0.5rem;
                            font-size: 0.85rem;
                            font-weight: bold;
                            border-radius: 0.25rem;
                            color: #fff;
                            text-align: center;
                        }
                        .btn-sm-status-success { background-color: #28a745; }
                        .btn-sm-status-secondary { background-color: #6c757d; }
                        .btn-sm-status-info { background-color: #17a2b8; }
                        .btn-sm-status-warning { background-color: #ffc107; color: #212529; }
                        .btn-sm-status-danger { background-color: #dc3545; }
                    </style>

                    <table class="table-custom">
                        <thead>
                            <tr>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Actif</th>
                                <th>Ouvert</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($programmes as $programme)
                                <tr>
                                    <td>{{ $programme->code }} : {{ $programme->nom }}</td>
                                    <td>{{ Str::limit($programme->description, 30) }}</td>

                                    <td>
                                        @if(in_array($usergroupId, [3,4,5,6]))
                                            <button class="btn-sm-status {{ $programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                                                {{ $programme->actif ? 'Oui' : 'Non' }}
                                            </button>
                                        @endif
                                        @if(in_array($usergroupId, [1,2]))
                                            <a href="{{ route('programmes.fonctactif', $programme->id) }}" 
                                               class="btn-sm-status {{ $programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                                                {{ $programme->actif ? 'Oui' : 'Non' }}
                                            </a>
                                        @endif
                                    </td>

                                    <td>
                                        @if(in_array($usergroupId, [3,5,6]))
                                            <button class="btn-sm-status {{ $programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}" disabled>
                                                {{ $programme->ouvert ? 'Ouvert' : 'Fermé' }}
                                            </button>
                                        @endif
                                        @if(in_array($usergroupId, [1,2,4]))
                                            <a href="{{ route('programmes.fonctouvert', $programme->id) }}" 
                                               class="btn-sm-status {{ $programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                                                {{ $programme->ouvert ? 'Ouvert' : 'Fermé' }}
                                            </a>
                                        @endif
                                    </td>

                                    <td>
                                        <a href="{{ route('programmes.show', $programme->id) }}" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>

                                        @if(in_array($usergroupId, [2])) 
                                            <a href="{{ route('programmes.edit', $programme->id) }}" class="btn-sm-status btn-sm-status-warning">
                                                <i class="bi bi-pen"></i>
                                            </a>
                                            <a href="{{ route('programmes.destroy', $programme->id) }}" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer ce programme ?')">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- End Table -->

                </div>
            </div>

        </div>
    </div>
</section>
@endsection
