@extends('layouts.app')

@section('title', 'Groupe Utilisateurs')

@section('content')
<div class="pagetitle">
  <h1>Structures</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Structures</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="{{ route('usergroups.create') }}" class="btn btn-primary rounded-pill">
              <i class="bi bi-plus-circle"></i> Ajouter
            </a>
          </h5>

          <style>
            .table-custom {
              width: 100%;
              border-collapse: collapse;
              border: 1px solid #dee2e6;
            }
            .table-custom th,
            .table-custom td {
              border: 1px solid #dee2e6;
              padding: 0.5rem 0.75rem;
              vertical-align: middle;
            }
            .table-custom thead th {
              background-color: #343a40;
              color: #fff;
              text-align: center;
              text-transform: uppercase;
              letter-spacing: 0.5px;
            }
            .table-custom tbody td {
              text-align: left;
            }
            .table-custom tbody tr:nth-child(odd) {
              background-color: #f8f9fa;
            }
            .table-custom tbody tr:hover {
              background-color: #e9ecef;
            }
            .btn-sm-status {
              padding: 0.25rem 0.5rem;
              font-size: 0.85rem;
              font-weight: bold;
              border-radius: 0.25rem;
              color: #fff;
              text-align: center;
            }
            .btn-sm-status-success { background-color: #28a745; }
            .btn-sm-status-secondary { background-color: #6c757d; }
            .btn-sm-status-info { background-color: #17a2b8; }
            .btn-sm-status-warning { background-color: #ffc107; color: #212529; }
            .btn-sm-status-danger { background-color: #dc3545; }
          </style>

          <table class="table-custom">
            <thead>
              <tr>
                <th>Nom</th>
                <th>Description</th>
                <th></th>
                <th></th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              @foreach($usergroups as $group)
              <tr>
                <td>{{ $group->nom }}</td>
                <td>{{ $group->description }}</td>
                <td></td>
                <td></td>
                <td>
                  <a href="{{ route('usergroups.edit', $group->id) }}" class="btn-sm-status btn-sm-status-warning">
                    <i class="bi bi-pen"></i>
                  </a>
                  <a href="{{ route('usergroups.destroy', $group->id) }}"
                     class="btn-sm-status btn-sm-status-danger"
                     onclick="return confirm('Supprimer ce groupe ?')">
                    <i class="bi bi-trash"></i>
                  </a>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>

        </div>
      </div>

    </div>
  </div>
</section>
@endsection
