@extends('layouts.app')
@section('title', 'Utilisateurs')

@section('content')
<div class="pagetitle">
  <h1>Liste des Utilisateurs</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item active">Utilisateurs</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="card">
    <div class="card-body">
      <h5 class="card-title">
        <a href="{{ route('users.create') }}" class="btn btn-primary rounded-pill">
          <i class="bi bi-plus-circle"></i> Nouvel utilisateur
        </a>
      </h5>

      <style>
        .table-custom {
          width: 100%;
          border-collapse: collapse;
          border: 1px solid #dee2e6;
        }
        .table-custom th,
        .table-custom td {
          border: 1px solid #dee2e6;
          padding: 0.5rem 0.75rem;
          vertical-align: middle;
        }
        .table-custom thead th {
          background-color: #343a40;
          color: #fff;
          text-align: center;
          text-transform: uppercase;
          letter-spacing: 0.5px;
        }
        .table-custom tbody td {
          text-align: left;
        }
        .table-custom tbody tr:nth-child(odd) {
          background-color: #f8f9fa;
        }
        .table-custom tbody tr:hover {
          background-color: #e9ecef;
        }
        .btn-sm-status {
          padding: 0.25rem 0.5rem;
          font-size: 0.85rem;
          font-weight: bold;
          border-radius: 0.25rem;
          color: #fff;
          text-align: center;
        }
        .btn-sm-status-success { background-color: #28a745; }
        .btn-sm-status-secondary { background-color: #6c757d; }
        .btn-sm-status-info { background-color: #17a2b8; }
        .btn-sm-status-warning { background-color: #ffc107; color: #212529; }
        .btn-sm-status-danger { background-color: #dc3545; }
      </style>

      <table class="table-custom">
        <thead>
          <tr>
            <th>Nom</th>
            <th>Email</th>
            <th>Groupe</th>
            <th>Actif</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          @foreach($users as $user)
          <tr>
            <td>{{ $user->name }}</td>
            <td>{{ $user->email }}</td>
            <td>{{ $user->usergroup ? $user->usergroup->nom : 'N/A' }}</td>
            <td>
              <a href="{{ route('users.actif', $user->id) }}" 
                 class="btn-sm-status {{ $user->is_active ? 'btn-sm-status-success' : 'btn-sm-status-secondary' }}">
                {{ $user->is_active ? 'Oui' : 'Non' }}
              </a>
            </td>
            <td>
              <a href="{{ route('users.edit', $user->id) }}" class="btn-sm-status btn-sm-status-warning">
                <i class="bi bi-pen"></i>
              </a>
              <a href="{{ route('users.destroy', $user->id) }}"
                 class="btn-sm-status btn-sm-status-danger"
                 onclick="return confirm('Supprimer cet utilisateur ?')">
                <i class="bi bi-trash"></i>
              </a>
            </td>
          </tr>
          @endforeach
        </tbody>
      </table>

    </div>
  </div>
</section>
@endsection
