<?php $__env->startSection('title', 'Programme'); ?>

<?php $__env->startSection('content'); ?>

<div class="pagetitle">
    <h1>Détails du Programme</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(url('index.html')); ?>">Accueil</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('programmes')); ?>">Programmes</a></li>
            <li class="breadcrumb-item active">Détails</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm">
        <div class="card-body">

            
            <h3 class="mb-4">Programme : <strong><?php echo e($programme->nom); ?></strong></h3>

            
            <?php if(Session::has('status')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(Session::get('status')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
			
			<?php
				$usergroupId = Auth::user()->usergroup_id;
			?>

			
			<div class="row justify-content-start mb-4">
				<div class="col-md-9"> 
					<div class="callout callout-primary p-3 border border-primary rounded">
						<h5 class="mb-3 text-primary"><u>Informations générales</u></h5>
						<ul class="list-group list-group-flush">
							<li class="list-group-item d-flex justify-content-between">
								<b>Code :</b> <span><?php echo e($programme->code); ?></span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Intitulé :</b> <span><?php echo e($programme->nom); ?></span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Détails :</b> <span><?php echo e($programme->description); ?></span>
							</li>

							
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Programme activé :</b>
								<span>
									<?php if(in_array($usergroupId, [1,2,4])): ?>
										<a href="<?php echo e(route('programmes.fonctactif', $programme->id)); ?>" class="btn btn-sm <?php echo e($programme->actif ? 'btn-success' : 'btn-secondary'); ?>">
											<?php echo e($programme->actif ? 'OUI' : 'NON'); ?>

										</a>
									<?php else: ?>
										<button class="btn btn-sm <?php echo e($programme->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
											<?php echo e($programme->actif ? 'OUI' : 'NON'); ?>

										</button>
									<?php endif; ?>
								</span>
							</li>

							
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Ouvert (en élaboration/revu) :</b>
								<span>
									<?php if(in_array($usergroupId, [1,2,4])): ?>
										<a href="<?php echo e(route('programmes.fonctouvert', $programme->id)); ?>" class="btn btn-sm <?php echo e($programme->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
											<?php echo e($programme->ouvert ? 'OUI' : 'NON'); ?>

										</a>
									<?php else: ?>
										<button class="btn btn-sm <?php echo e($programme->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled>
											<?php echo e($programme->ouvert ? 'OUI' : 'NON'); ?>

										</button>
									<?php endif; ?>
								</span>
							</li>

							
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Responsable programme :</b>
								<span>
									<?php if(in_array($usergroupId, [1,2])): ?>
										<?php if(isset($programme->user)): ?>
											<?php echo e($programme->user->name); ?> (<?php echo e($programme->user->email); ?>)
											<a href="<?php echo e(route('programmes.rpremove', $programme->id)); ?>" onclick="return confirm('Enlever ce RP ?')" class="text-danger ms-2">X</a>
										<?php else: ?>
											Non désigné
											<a href="<?php echo e(route('users.rpcreate', ['level' => 'program', 'id' => $programme->id])); ?>" class="btn btn-warning btn-sm ms-2">
												<i class="bi bi-plus-circle"></i> Choisir/Modifier RP
											</a>
										<?php endif; ?>
									<?php endif; ?>
								</span>
							</li>
						</ul>
					</div>
				</div>
			</div>


            
            <?php if(in_array($usergroupId, [1,2])): ?>
            <div class="mb-4">
				<?php if(!$programme->actif): ?>
					<a href="<?php echo e(route('programmes.fonctallactif', $programme->id)); ?>" class="btn <?php echo e($programme->actif ? 'btn-success' : 'btn-secondary'); ?> me-2">
						<?php echo e($programme->actif ? 'Désactiver tout' : 'Activer tout'); ?>

					</a>
				<?php endif; ?>
				<?php if(!$programme->ouvert): ?>
					<a href="<?php echo e(route('programmes.fonctallouvert', $programme->id)); ?>" class="btn <?php echo e($programme->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
						<?php echo e($programme->ouvert ? 'Fermer tout' : 'Ouvrir tout'); ?>

					</a>
				<?php endif; ?>
            </div>
            <?php endif; ?>

            
            <div class="callout callout-danger mb-4 p-3 border border-danger rounded">
                <h5 class="mb-3 text-danger"><u>Liste des actions</u></h5>

                <?php if(in_array($usergroupId, [1,2,4]) && $programme->actif && $programme->ouvert): ?>
                    <a href="<?php echo e(route('actions.create', ['progid' => $programme->id])); ?>" class="btn btn-primary mb-3">
                        <i class="bi bi-plus-circle"></i> Ajouter une action
                    </a>
                <?php endif; ?>

                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Code</th>
                            <th>Libellé</th>
                            <th>Actif</th>
                            <th>Ouvert</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $programme->actions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $action): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($action->code); ?></td>
                            <td><?php echo e($action->nom); ?></td>
                            <td class="text-center">
                                <a href="<?php echo e(route('actions.actif', $action->id)); ?>" class="btn btn-sm <?php echo e($action->actif ? 'btn-success' : 'btn-secondary'); ?>">
                                    <?php echo e($action->actif ? 'OUI' : 'NON'); ?>

                                </a>
                            </td>
                            <td class="text-center">
                                <a href="<?php echo e(route('actions.ouvert', $action->id)); ?>" class="btn btn-sm <?php echo e($action->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
                                    <?php echo e($action->ouvert ? 'OUI' : 'NON'); ?>

                                </a>
                            </td>
                            <td class="text-center">
                                <a href="<?php echo e(route('actions.show', $action->id)); ?>" class="btn btn-info btn-sm"><i class="bi bi-eye"></i></a>
                                <?php if(in_array($usergroupId, [1,2,4])): ?>
                                    <a href="<?php echo e(route('actions.edit', $action->id)); ?>" class="btn btn-warning btn-sm"><i class="bi bi-pen"></i></a>
                                    <a href="<?php echo e(route('actions.destroy', $action->id)); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer cette action ?')"><i class="bi bi-trash"></i></a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <div class="callout callout-info p-3 border border-info rounded">
                <h5 class="mb-3 text-info"><u>Historique des RPs</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-info text-center">
                        <tr>
                            <th>Responsable</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $programme->responsables ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($resp->user); ?></td>
                            <td><?php echo e($resp->datedebut); ?></td>
                            <td><?php echo e($resp->datefin ?? 'En cours'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/programmes/show.blade.php ENDPATH**/ ?>