

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-4">Modifier l'évaluation </h2>

    
    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    
    <form action="<?php echo e(route('evaluations.update', $evaluation->id)); ?>" method="POST">
        <?php echo csrf_field(); ?> 

        <input type="hidden" name="activite_id" value="<?php echo e($evaluation->activite_id); ?>">
		<label class="form-label">Activité : <?php echo e($evaluation->activite->nom); ?></label>
		<input type="hidden" name="previsionactivite_id" value="<?php echo e($evaluation->previsionactivite_id); ?>">
		<label class="form-label">Prévision : <?php echo e($evaluation->prevision->niveaucible); ?></label>
		
        <div class="mb-3">
			<input type="hidden" name="taux_prevision" value="<?php echo e($evaluation->taux_prevision); ?>">
            <label class="form-label">Niveau cible : <?php echo e($evaluation->taux_prevision); ?></label>

        </div>
		
		<div class="mb-3">
			<label class="form-label"><b>Etape</b></label>
			<select name="etape_id" class="form-control" required>
			  <option value="">-- Choisir --</option>
			  <?php $__currentLoopData = $etapes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
				<option value="<?php echo e($s->id); ?>" <?php echo e($s->id == $evaluation->etape_id ? 'selected' : ''); ?>>
				  <?php echo e($s->nom); ?> (<?php echo e($s->niveauexec); ?>%)
				</option>
			  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
			</select>
        </div>

        <div class="mb-3">
            <label for="date_evaluation" class="form-label">Date d'évaluation</label>
            <input type="date" name="date_evaluation" id="date_evaluation" class="form-control" required
                   value="<?php echo e(old('date_evaluation', $evaluation->date_evaluation)); ?>">
        </div>

        <button type="submit" class="btn btn-primary">Mettre à jour</button>
        <a href="<?php echo e(route('evaluations.update', $evaluation->id)); ?>" class="btn btn-secondary">Annuler</a>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/evaluations/edit.blade.php ENDPATH**/ ?>