
<?php $__env->startSection('title', 'Activité'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h1>Prévisions Activité</h1>
    <h5>Pour ajouter une étape, l'activité doit être modifiable (états : invalide, inactif ou ouvert)</h5>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('activites.show', $activite->id)); ?>">Détails Activité</a></li>
            <li class="breadcrumb-item active">Planning des prévisions</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            
            <?php if(Session::has('status')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(Session::get('status')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <h4 class="mb-3 text-danger">Activité : <strong><?php echo e($activite->nom); ?></strong></h4>

            
            <div class="callout mb-4 p-3 border border-danger rounded">
                <h5 class="text-danger mb-3"><u>Informations générales</u></h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex justify-content-between"><b>Code :</b> <span><?php echo e($activite->code); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Nom :</b> <span><?php echo e($activite->nom); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Description :</b> <span><?php echo e($activite->description ?? '-'); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Montant :</b> <span><?php echo e($activite->montant ?? '-'); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Date Début :</b> <span><?php echo e($activite->datedebut); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Date Fin :</b> <span><?php echo e($activite->datefin ?? 'En cours'); ?></span></li>
                    <li class="list-group-item">
                        <b>Etat :</b>
                        <span style="color: <?php echo e($activite->valide ? 'green' : 'red'); ?>; font-weight:bold;"><?php echo e($activite->valide ? 'Validée' : 'Non validée'); ?></span> |
                        <span style="color: <?php echo e($activite->actif ? 'green' : 'red'); ?>; font-weight:bold;"><?php echo e($activite->actif ? 'Activée' : 'Non activée'); ?></span> |
                        <span style="color: <?php echo e($activite->ouvert ? 'red' : 'gray'); ?>; font-weight:bold;"><?php echo e($activite->ouvert ? 'Révision ou élaboration' : 'Pas de modification'); ?></span>
                    </li>
                </ul>
            </div>

            
            <div class="callout mb-4 p-3 border border-danger rounded">
                <h4 class="text-danger mb-3"><u>Planning</u></h4>
                <?php
                    $canAddPlanning = $activite->ouvert || !$activite->actif || !$activite->valide;
                    $groupedPrevisions = $activite->previsions->sortBy('dateevaluation')->groupBy(fn($item) => $item->extrant->nom ?? 'Sans extrant');
                ?>

                <?php $__currentLoopData = $groupedPrevisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extrant => $previsions): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <h5 class="text-danger mt-3 mb-2"><u>Extrant : <?php echo e($extrant); ?></u></h5>
                    <?php $extrantId = $previsions->first()->extrant->id ?? null; ?>

                    <?php if($canAddPlanning): ?>
                        <a href="<?php echo e(route('previsionactivites.create', ['activiteid' => $activite->id, 'extrantid' => $extrantId])); ?>" class="btn btn-danger mb-3 rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter un Planning
                        </a>
                    <?php endif; ?>

                    <table class="table table-bordered table-striped">
                        <thead class="table-danger text-center">
                            <tr>
                                <th>Ordre</th>
                                <th>Date de référence</th>
                                <th>Taux</th>
                                <th>Commentaire</th>
                                <th>Outils</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $previsions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $prev): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php $planning_isfree = $prev->evaluations->isEmpty(); ?>
                                <tr>
                                    <td><?php echo e($prev->ordreevaluation ?? '-'); ?></td>
                                    <td><?php echo e($prev->dateevaluation); ?></td>
                                    <td><?php echo e($prev->niveaucible); ?> %</td>
                                    <td><?php echo e($prev->commentaire ?? '-'); ?></td>
                                    <td class="text-center">
                                        <?php if($planning_isfree): ?>
                                            <a href="<?php echo e(route('previsionactivites.edit', $prev->id)); ?>" class="btn btn-warning btn-sm"><i class="bi bi-pen"></i></a>
                                            <a href="<?php echo e(route('previsionactivites.destroy', $prev->id)); ?>" onclick="return confirm('Enlever cette étape de planning?')" class="btn btn-danger btn-sm"><i class="bi bi-trash"></i></a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            
            <?php $canEvaluate = $evalwaitings->isNotEmpty() && $activite->valide && $activite->actif && !$activite->ouvert; ?>
            <?php if($canEvaluate): ?>
                <div class="d-flex justify-content-center mb-4">
                    <a href="<?php echo e(route('activites.evaluate', ['id' => $activite->id])); ?>" class="btn btn-success rounded-pill">
                        <i class="bi bi-clipboard-check"></i> Évaluation
                    </a>
                </div>
            <?php endif; ?>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/activites/planning.blade.php ENDPATH**/ ?>