<?php $__env->startSection('title', 'Accueil'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h1>Partenaires</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">Partenaires</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <a href="<?php echo e(route('partenaires.create')); ?>" class="btn btn-primary rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter
                        </a>
                    </h5>

                    <style>
                        .table-custom {
                            width: 100%;
                            border-collapse: collapse;
                            border: 1px solid #dee2e6;
                        }
                        .table-custom th,
                        .table-custom td {
                            border: 1px solid #dee2e6;
                            padding: 0.5rem 0.75rem;
                            vertical-align: middle;
                        }

                        /* En-tête sombre et centrée */
                        .table-custom thead th {
                            background-color: #343a40;
                            color: #fff;
                            text-transform: uppercase;
                            letter-spacing: 0.5px;
                            text-align: center;
                        }

                        /* Contenu des cellules justifié à gauche */
                        .table-custom tbody td {
                            text-align: left;
                        }

                        /* Lignes alternées et survol */
                        .table-custom tbody tr:nth-child(odd) {
                            background-color: #f8f9fa;
                        }
                        .table-custom tbody tr:hover {
                            background-color: #e9ecef;
                        }

                        /* Boutons stylisés */
                        .btn-sm-status {
                            padding: 0.25rem 0.5rem;
                            font-size: 0.85rem;
                            font-weight: bold;
                            border-radius: 0.25rem;
                            color: #fff;
                            text-align: center;
                        }
                        .btn-sm-status-success { background-color: #28a745; }
                        .btn-sm-status-secondary { background-color: #6c757d; }
                        .btn-sm-status-info { background-color: #17a2b8; }
                        .btn-sm-status-danger { background-color: #dc3545; }
                    </style>

                    <table class="table-custom">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Type partenaire</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $partenaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partenaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($partenaire->code); ?></td>
                                    <td><?php echo e($partenaire->nom); ?></td>
                                    <td><?php echo e($partenaire->desctiption ?? '-'); ?></td>
                                    <td><?php echo e($partenaire->typepartenaire ? $partenaire->typepartenaire->type : 'Non défini'); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('partenaires.edit', $partenaire->id)); ?>" class="btn-sm-status btn-sm-status-info">
                                            <i class="bi bi-pen"></i>
                                        </a>
                                        <a href="<?php echo e(route('partenaires.destroy', $partenaire->id)); ?>" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer ce partenaire ?')">
                                            <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <!-- End Table -->

                </div>
            </div>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/partenaires/index.blade.php ENDPATH**/ ?>