<?php $__env->startSection('title', 'Groupe Activités'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h1>Groupe Activités</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">Groupe Activités</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <a href="<?php echo e(route('groupeactivites.create')); ?>" class="btn btn-primary rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter
                        </a>
                    </h5>

                    <style>
                        .table-custom {
                            width: 100%;
                            border-collapse: collapse;
                            border: 1px solid #dee2e6;
                        }
                        .table-custom th,
                        .table-custom td {
                            border: 1px solid #dee2e6;
                            padding: 0.5rem 0.75rem;
                            vertical-align: middle;
                        }
                        .table-custom thead th {
                            background-color: #343a40;
                            color: #fff;
                            text-align: center;
                            text-transform: uppercase;
                            letter-spacing: 0.5px;
                        }
                        .table-custom tbody td {
                            text-align: left;
                        }
                        .table-custom tbody tr:nth-child(odd) {
                            background-color: #f8f9fa;
                        }
                        .table-custom tbody tr:hover {
                            background-color: #e9ecef;
                        }
                        .btn-sm-status {
                            padding: 0.25rem 0.5rem;
                            font-size: 0.85rem;
                            font-weight: bold;
                            border-radius: 0.25rem;
                            color: #fff;
                            text-align: center;
                        }
                        .btn-sm-status-info { background-color: #17a2b8; }
                        .btn-sm-status-danger { background-color: #dc3545; }
                    </style>

                    <table class="table-custom">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Nom</th>
                                <th>CSD</th>
                                <th>Description</th>
                                <th>Voir</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $groupeactivites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupeactivite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($groupeactivite->code); ?></td>
                                    <td><?php echo e($groupeactivite->nom); ?></td>
                                    <td><?php echo e($groupeactivite->csd->nom ?? '-'); ?></td>
                                    <td><?php echo e($groupeactivite->description); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('groupeactivites.show', $groupeactivite->id)); ?>" 
                                           class="btn-sm-status btn-sm-status-info">
                                           <i class="bi bi-eye"></i>
                                        </a>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('groupeactivites.edit', $groupeactivite->id)); ?>" 
                                           class="btn-sm-status btn-sm-status-info">
                                           <i class="bi bi-pen"></i>
                                        </a>
                                        <a href="<?php echo e(route('groupeactivites.destroy', $groupeactivite->id)); ?>" 
                                           class="btn-sm-status btn-sm-status-danger"
                                           onclick="return confirm('Supprimer ce groupe ?')">
                                           <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    <!-- End Table -->

                </div>
            </div>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/groupeactivites/index.blade.php ENDPATH**/ ?>