

<?php $__env->startSection('content'); ?>
<div class="container">
    <h2 class="mb-4">Ajouter une prévision pour l'activité #<?php echo e($activiteid); ?></h2>

    
    <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
    <?php endif; ?>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    
    <form action="<?php echo e(route('previsionactivites.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <input type="hidden" name="activite_id" value="<?php echo e($activiteid); ?>">

        <div class="mb-3">
			<label for="ordreevaluation" class="form-label">Ordre d'évaluation</label>
			<input type="number" name="ordreevaluation" id="ordreevaluation" class="form-control" step="1" required
				   value="<?php echo e(old('ordreevaluation', $nextOrdre)); ?>">
		</div>

        <div class="mb-3">
            <label for="niveaucible" class="form-label">Niveau cible</label>
            <input type="number" name="niveaucible" id="niveaucible" class="form-control" step="0.01" min="0" max="999.99" required
                   value="<?php echo e(old('niveaucible')); ?>">
        </div>

        <div class="mb-3">
            <label for="dateevaluation" class="form-label">Date d'évaluation</label>
            <input type="date" name="dateevaluation" id="dateevaluation" class="form-control" required
                   value="<?php echo e(old('dateevaluation')); ?>">
        </div>

        <button type="submit" class="btn btn-primary">Enregistrer</button>
        <a href="<?php echo e(route('activites.planning', $activiteid)); ?>" class="btn btn-secondary">Annuler</a>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\phaso\resources\views/previsionactivites/create.blade.php ENDPATH**/ ?>