<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\EvaluationStructure;
use App\Models\Structure;
use App\Models\Programme;
 use App\Models\Activite;
use App\Models\Action;
use App\Models\Evaluation;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
class DashboardController extends Controller
{
    //
public function index()
    {
        /* $structuresEnRetard = EvaluationStructure::with('structure')
            ->whereDate('updated_at', '<', Carbon::now()->subYear())
            ->get(['structure_id', 'anneeref', 'updated_at']);
	$nombreStructuresEnRetard = $structuresEnRetard->unique('structure_id')->count();		*/
$today = Carbon::today();       
      $structuresEnRetard = Structure::whereHas('activites', function ($q) use ($today) {
          $q->where('actif', true)
            ->where('ouvert', true)
            ->whereHas('evaluations', function ($ev) use ($today) {
                // On veut uniquement les valuations dont la date_reference est passe
                // et qui sont soit non values, soit values aprs la date_reference
                $ev->whereDate('date_reference', '<', $today)
                   ->where(function ($cond) {
                       $cond->whereNull('date_evaluation')
                            ->orWhereColumn('date_evaluation', '>', 'date_reference');
                   });
            });
      })
      ->with(['activites' => function ($q) use ($today) {
          $q->where('actif', true)
            ->where('ouvert', true)
            ->with(['evaluations' => function ($ev) use ($today) {
                $ev->whereDate('date_reference', '<', $today)
                   ->where(function ($cond) {
                       $cond->whereNull('date_evaluation')
                            ->orWhereColumn('date_evaluation', '>', 'date_reference');
                   });
            }]);
      }])
      ->get();
      
      $nombreStructuresEnRetard = $structuresEnRetard->count();

  
    $topStructures = Evaluation::select(
                                      'evaluations.id',
                                      'structures.nom as structure',
                                      'activites.nom as activite',
                                      'evaluations.taux_prevision',
                                      'evaluations.taux_realisation',
                                      DB::raw('(evaluations.taux_realisation - evaluations.taux_prevision) as ecart')
                                  )
                                  ->join('activites', 'activites.id', '=', 'evaluations.activite_id')
                                  ->join('structures', 'structures.id', '=', 'activites.structure_id')
                                  ->whereRaw('(evaluations.taux_realisation - evaluations.taux_prevision) > 0')
                                  ->orderByDesc(DB::raw('(evaluations.taux_realisation - evaluations.taux_prevision)'))
                                  ->limit(10)
                                  ->get();
		//	dd($topStructures); 

     

        $lowStructures = Evaluation::select(
                                      'evaluations.id',
                                      'structures.nom as structure',
                                      'activites.nom as activite',
                                      'evaluations.taux_prevision',
                                      'evaluations.taux_realisation',
                                      DB::raw('(evaluations.taux_realisation - evaluations.taux_prevision) as ecart')
                                  )
                                  ->join('activites', 'activites.id', '=', 'evaluations.activite_id')
                                  ->join('structures', 'structures.id', '=', 'activites.structure_id')
                                  ->whereRaw('(evaluations.taux_realisation - evaluations.taux_prevision) <  0')
                                  ->orderByDesc(DB::raw('(evaluations.taux_realisation - evaluations.taux_prevision)'))
                                  ->limit(10)
                                  ->get();


     
      /*  $tauxParProgramme = Programme::with(['actions.activites'])
            ->get()
            ->map(function ($programme) {
                $tauxMoyen = $programme->actions->flatMap->activites
                    ->avg(fn($a) => (int) $a->prog_actif * 100);

                return [
                    'nom' => $programme->nom,
                    'taux_moyen' => round($tauxMoyen, 2),
                ];
            })
            ->sortByDesc('taux_moyen')
            ->take(5)
            ->values();*/
            $tauxParProgramme = Programme::with([
                                'actions.activites.evaluations'
                            ])
                            ->get()
                            ->map(function ($programme) {
                        
                                // Rcuprer toutes les valuations de toutes les activits du programme
                                $evaluations = $programme->actions
                                    ->flatMap->activites
                                    ->flatMap->evaluations;
                        
                                if ($evaluations->isEmpty()) {
                                    return [
                                        'nom' => $programme->nom,
                                        'taux_moyen' => 0
                                    ];
                                }
                         
                                // Calcul taux moyen = moyenne (taux_realisation / taux_prevision * 100)
                                $tauxMoyen = $evaluations->map(function ($e) {
                                    if ($e->taux_prevision == 0) return 0;
                                    return ($e->taux_realisation / $e->taux_prevision) * 100;
                                })->avg();
                        
                                return [
                                    'nom' => $programme->nom,
                                    'taux_moyen' => round($tauxMoyen, 2),
                                ];
                            })
                            ->sortByDesc('taux_moyen')
                            ->take(5)
                            ->values();

        return view('welcome', compact(
            'structuresEnRetard',
'nombreStructuresEnRetard',
            'topStructures',
            'lowStructures',
            'tauxParProgramme'
        ));
    }
}
