<?php
namespace App\Http\Controllers;
use App\Models\Indicateur;
use App\Models\Extrant;
use App\Models\Etape;
use App\Models\Activite;
use App\Models\Evaluation;
use Illuminate\Http\Request;

class IndicateursController extends Controller
{
    public function index()
    {
        /*$extrants = Extrant::with('activite.evaluations.etape')
            ->get()
            ->map(function($extrant) {
                $activites = $extrant->activite ? [$extrant->activite] : [];
                $tauxTotal = 0;
                $count = 0;

                foreach($activites as $activite){
                    foreach($activite->evaluations as $evaluation){
                        if($evaluation->etape){
                            $tauxTotal += $evaluation->etape->niveauexec * 100; // en pourcentage
                            $count++;
                        }
                    }
                }

                $extrant->taux_execution = $count > 0 ? round($tauxTotal / $count, 2) : 0;
                return $extrant;
            });

        return view('indicateurs.index', compact('extrants'));*/
         try {
            $extrants = Extrant::with('activite.evaluations.etape')
                ->get()
                ->map(function ($extrant) {
                    $activites = $extrant->activite ? [$extrant->activite] : [];
                    $tauxTotal = 0;
                    $count = 0;

                    foreach ($activites as $activite) {
                        foreach ($activite->evaluations as $evaluation) {
                            if ($evaluation->etape) {
                                $tauxTotal += $evaluation->etape->niveauexec * 100;
                                $count++;
                            }
                        }
                    }

                    $extrant->taux_execution = $count > 0 ? round($tauxTotal / $count, 2) : 0;
                    return $extrant;
                });

            return view('indicateurs.index', compact('extrants'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des indicateurs : ' . $e->getMessage());
        }
    }


    public function show($id)
    {
        /*$extrant = Extrant::with('activite.evaluations.etape')->findOrFail($id);

        $activite = $extrant->activite;
        $tauxTotal = 0;
        $count = 0;

        if($activite){
            foreach($activite->evaluations as $evaluation){
                if($evaluation->etape){
                    $tauxTotal += $evaluation->etape->niveauexec * 100;
                    $count++;
                }
            }
            $activite->taux_execution = $count > 0 ? round($tauxTotal / $count, 2) : 0;
        }

        return view('extrants.show', compact('extrant', 'activite'));*/
         try {
            $extrant = Extrant::with('activite.evaluations.etape')->findOrFail($id);
            $activite = $extrant->activite;

            $tauxTotal = 0;
            $count = 0;

            if ($activite) {
                foreach ($activite->evaluations as $evaluation) {
                    if ($evaluation->etape) {
                        $tauxTotal += $evaluation->etape->niveauexec * 100;
                        $count++;
                    }
                }
                $activite->taux_execution = $count > 0 ? round($tauxTotal / $count, 2) : 0;
            }

            return view('extrants.show', compact('extrant', 'activite'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’affichage des détails : ' . $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'code' => 'required|string|max:20',
            'nom' => 'required|string|max:100',
            'valeur_cible' => 'required|numeric',
            'valeur_actuelle' => 'nullable|numeric',
            'description' => 'nullable|string',
        ]);
       /* return Indicateur::create($data);*/
         try {
            

            $indicateur = Indicateur::create($validated);

            if ($indicateur) {
                return redirect()->back()->with('success', 'Indicateur ajouté avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de l’enregistrement de l’indicateur.');
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return redirect()->back()->withErrors($e->errors())->withInput();
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    public function update(Request $request, $id)
    {
        $i = Indicateur::findOrFail($id);
        $data = $request->validate([
            'code' => 'sometimes|string|max:20',
            'nom' => 'sometimes|string|max:100',
            'valeur_cible' => 'sometimes|numeric',
            'valeur_actuelle' => 'nullable|numeric',
            'description' => 'nullable|string',
        ]);
       /* $i->update($data);
        return $i;*/
        try {
        

           

            if ($i->update($data)) {
                return redirect()->back()->with('success', 'Indicateur mis à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour de l’indicateur.');
            }
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->back()->with('error', 'Indicateur introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    public function destroy($id) {
	 /*Indicateur::findOrFail($id)->delete();
	 return response()->json(['message'=>'Indicateur supprimé']); */
   
   try {
            $indicateur = Indicateur::findOrFail($id);

            if ($indicateur->delete()) {
                return redirect()->back()->with('success', 'Indicateur supprimé avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la suppression de l’indicateur.');
            }
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->back()->with('error', 'Indicateur introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
   }
}
