<?php

namespace App\Http\Controllers;

use App\Models\Programme;
use App\Models\Action;
use App\Models\ResponsableProgramme;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ProgrammesController extends Controller
{
    public function index()
    {
      
        
         try {
          $user = Auth::user();
           $groupId = $user->usergroup_id;
           if ($groupId == 4) {
              $programmesrp = Programme::whereHas('responsables', function ($query) use ($user) {
              $query->where('user_id', $user->id);
              })->orderBy('code', 'asc')->get();
              $programmes = Programme::whereNotIn('id', $programmesrp->pluck('id'))
                                    ->orderBy('code', 'asc')
                                    ->get();
              
return view('programmes.index', compact('programmesrp','programmes'));
            
           } elseif ($groupId == 5 || $groupId == 6) {
              $programmes = Programme::select('programmes.*')
                          ->join('actions', 'actions.programme_id', '=', 'programmes.id')
                          ->join('structure_action', 'structure_action.action_id', '=', 'actions.id')
                          ->join('responsablestructures', 'responsablestructures.structure_id', '=', 'structure_action.structure_id')
                          ->where('responsablestructures.user_id', $user->id)
                          ->distinct()
                          ->orderBy('programmes.code', 'asc')
                          ->get();

return view('programmes.index', compact('programmes'));
            
           } 
           else {
             $programmes = Programme::orderBy('code', 'asc')->get();
             return view('programmes.index', compact('programmes'));
           }
            
           
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des programmes : ' . $e->getMessage());
        }
    }

    public function create()
    {
       
          try {
            return view('programmes.create');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’ouverture du formulaire : ' . $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:2|unique:programmes,code',
            'nom' => 'required|string|max:200|unique:programmes,nom',
            'description' => 'nullable|string',
        ]);

       
         try {
        

            $programme = Programme::create($validated);

            if ($programme) {
                return redirect()->route('programmes.index')->with('success', 'Programme ajouté avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de l’ajout du programme.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    public function show($id)
    {
        /*if(!Session::has('utilisateur') and !Session::has('type')){
            return view('utilisateurs/login');
        }
		$programme = Programme::with('actions', 'user', 'responsables')->findOrFail($id);
		//dd($programme); die();
		$programme->refresh();
		
        return view('programmes.show', compact('programme'));*/
         try {
            $programme = Programme::with('actions', 'user', 'responsables')->findOrFail($id);
            $programme->refresh();
            return view('programmes.show', compact('programme'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’affichage du programme : ' . $e->getMessage());
        }
    }
    
      public function showrp($id)
    {
        /*if(!Session::has('utilisateur') and !Session::has('type')){
            return view('utilisateurs/login');
        }
		$programme = Programme::with('actions', 'user', 'responsables')->findOrFail($id);
		//dd($programme); die();
		$programme->refresh();
		
        return view('programmes.show', compact('programme'));*/
         try {
            $programme = Programme::with('actions', 'user', 'responsables')->findOrFail($id);
            $programme->refresh();
            return view('programmes.showrp', compact('programme'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’affichage du programme : ' . $e->getMessage());
        }
    }

    public function edit($id)
    {
        /*$programme = Programme::findOrFail($id);
        return view('programmes.edit', compact('programme'));*/
        try {
            $programme = Programme::findOrFail($id);
            return view('programmes.edit', compact('programme'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’ouverture du formulaire d’édition : ' . $e->getMessage());
        }
    }

    public function update(Request $request, $id)
    {
       /* $programme = Programme::findOrFail($id);

        $validated = $request->validate([
            'code' => 'required|string|max:2|unique:programmes,code,' . $programme->id,
            'nom' => 'required|string|max:100|unique:programmes,nom,' . $programme->id,
            'description' => 'nullable|string',
        ]);

        $programme->update($validated);

        return redirect()->route('programmes.index')->with('success', 'Programme mis à jour avec succès.');*/
        $programme = Programme::findOrFail($id);

   
    $request->validate([
        'code' => 'required|string|max:2|unique:programmes,code,' . $programme->id,
        'nom' => 'required|string|max:100|unique:programmes,nom,' . $programme->id,
        'description' => 'nullable|string',
    ]);

    try {
        $updated = $programme->update($request->all());

        if ($updated) {
            return redirect()->route('programmes.index')
                ->with('success', 'Programme mis à jour avec succès.');
        } else {
            return redirect()->route('programmes.index')
                ->with('error', 'Échec de la mise à jour du programme.');
        }
    } catch (\Exception $e) {
        return redirect()->route('programmes.index')
            ->with('error', 'Erreur inattendue lors de la mise à jour : ' . $e->getMessage());
    }
    }

    public function destroy($id)
    {
		/*try {
			$programme = Programme::findOrFail($id);
			$programme->delete();
			return redirect()->route('programmes.index')->with('success', 'Programme supprimé avec succès.');
		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}*/
    try {
            $programme = Programme::findOrFail($id);

            if ($programme->delete()) {
                return redirect()->route('programmes.index')->with('success', 'Programme supprimé avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la suppression du programme.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    
    public function fonctactif($id)
    {
    try {
            $programme = Programme::findOrFail($id);
            $newstate = !$programme->actif;
            $programme->actif = $newstate;
            $programme->save();

            if (!$newstate) {
                DB::statement('CALL update_programme_actif(?, ?)', [$id, $newstate]);
                $programme->ouvert = $newstate;
                $programme->save();
                DB::statement('CALL update_programme_ouvert(?, ?)', [$id, $newstate]);
            }

            return redirect()->back()->with('success', 'État du programme mis à jour avec succès.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la mise à jour de l’état du programme : ' . $e->getMessage());
        }
    }
	
    public function fonctouvert($id)
    {
        try {
            $programme = Programme::findOrFail($id);
            $newstate = !$programme->ouvert;

            if ($newstate && !$programme->actif) {
                return redirect()->back()->with('error', 'Impossible d’ouvrir un programme inactif. Activez-le d’abord.');
            }

            $programme->ouvert = $newstate;
            $programme->save();

            if (!$newstate) {
                DB::statement('CALL update_programme_ouvert(?, ?)', [$id, $newstate]);
            }

            return redirect()->back()->with('success', 'Statut d’ouverture du programme mis à jour avec succès.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du changement du statut d’ouverture : ' . $e->getMessage());
        }
    }
	
	public function rpremove($id)
    {
        /*$programme = Programme::findOrFail($id);
		$programme->user_id = null;
        if($programme->save()){
			$resprog = ResponsableProgramme::where('programme_id', $id)->orderBy('id', 'desc')->first();
			$resprog->datefin = now();
			$resprog->save();
			
			$user = User::find($resprog->user_id);
			$user->is_rp = false;
			$user->save();
		}
        return redirect()->back()->with('success', 'Statut d’ouverture du programme mis à jour.');
    }*/
    try {
            $programme = Programme::findOrFail($id);
            $programme->user_id = null;

            if ($programme->save()) {
                $resprog = ResponsableProgramme::where('programme_id', $id)->orderBy('id', 'desc')->first();

                if ($resprog) {
                    $resprog->datefin = now();
                    $resprog->save();

                    $user = User::find($resprog->user_id);
                    if ($user) {
                        $user->is_rp = false;
                        $user->save();
                    }
                }
                return redirect()->back()->with('success', 'Responsable de programme retiré avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec du retrait du responsable.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }
    
	public function fonctallactif($id)
    {
		try {
            $programme = Programme::findOrFail($id);
            $newstate = !$programme->actif;
            $programme->actif = $newstate;
            if($programme->save())
			{
				DB::statement('CALL update_programme_allactif(?, ?)', [$id, $newstate]);
			}

            return redirect()->back()->with('success', 'État du programme et dépendances mis à jour avec succès.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la mise à jour de l’état du programme : ' . $e->getMessage());
        }
    }
	
    public function fonctallouvert($id)
    {
        try {
            $programme = Programme::findOrFail($id);
            $newstate = !$programme->ouvert;

            if ($newstate && !$programme->actif) {
                return redirect()->back()->with('error', 'Impossible d’ouvrir un programme inactif. Activez-le d’abord.');
            }

            $programme->ouvert = $newstate;
            $programme->save();
			DB::statement('CALL update_programme_allouvert(?, ?)', [$id, $newstate]);

            return redirect()->back()->with('success', 'Statut d’ouverture du programme et dependance mis à jour avec succès.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du changement du statut d’ouverture : ' . $e->getMessage());
        }
    }
}

