<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Extrant extends Model
{
    use HasFactory;

    protected $table = 'extrants';
    protected $primaryKey = 'id';

    protected $fillable = [
        'nom',
        'activite_id',
		'debut',
		'fin',
    ];

    public $timestamps = true;

    public function activite()
    {
        return $this->belongsTo(Activite::class, 'activite_id', 'id');
    }
	
	public function previsions()
    {
        return $this->hasMany(PrevisionActivite::class, 'extrant_id', 'id');
    }
	
	public function evaluations()
    {
	    return $this->hasMany(Evaluation::class, 'extrant_id', 'id')
			->orderBy('taux_realisation', 'asc');
    }
}
