<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FinancementActivite extends Model
{
    use HasFactory;

    protected $table = 'financementactivites';
    protected $primaryKey = 'id';

    protected $fillable = [
        'partenaire_id',
        'activite_id',
        'montant',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    public function activite()
    {
        return $this->belongsTo(Activite::class, 'activite_id', 'id');
    }

    public function partenaire()
    {
        return $this->belongsTo(Partenaire::class, 'partenaire_id', 'id');
    }
}
