<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StructureActivite extends Model
{
    use HasFactory;

    protected $table = 'structure_activite';
    protected $primaryKey = 'id';

    protected $fillable = [
        'activite_id',
        'structure_id',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    public function activite()
    {
        return $this->belongsTo(Activite::class, 'action_id', 'id');
    }

    public function structure()
    {
        return $this->belongsTo(Structure::class, 'structure_id', 'id');
    }
}
