<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Programme;

class ProgrammeSeeder extends Seeder
{
    public function run(): void
    {
        $programmes = [
            [
                'code' => 'P1',
                'nom' => 'Programme d’Appui à la Gouvernance',
                'description' => 'Renforcement des capacités institutionnelles et de la gouvernance locale.',
                'actif' => true,
                'ouvert' => true,
            ],
            [
                'code' => 'P2',
                'nom' => 'Programme Santé et Nutrition',
                'description' => 'Appui aux initiatives communautaires de santé et nutrition.',
                'actif' => true,
                'ouvert' => false,
            ],
            [
                'code' => 'P3',
                'nom' => 'Programme Éducation de Qualité',
                'description' => 'Soutien à l’accès équitable à une éducation de qualité pour tous.',
                'actif' => true,
                'ouvert' => true,
            ],
        ];

        foreach ($programmes as $programme) {
            Programme::create($programme);
        }
    }
}
