@extends('layouts.app')
@section('title', 'Activité')

@section('content')
<div class="pagetitle">
    <h1>Détails Activité</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="{{ route('actions.show', $activite->action_id) }}">Détails Action</a></li>
            <li class="breadcrumb-item active">Détails Activité</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm">
        <div class="card-body">
            <h3 class="text-danger mb-4">Activité : <strong>{{ $activite->nom }}</strong></h3>

            {{-- Message Session --}}
            @if(Session::has('status'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ Session::get('status') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif

            @php $usergroupId = Auth::user()->usergroup_id; @endphp

            {{-- Informations générales --}}
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Informations générales</u></h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex justify-content-between"><b>Code :</b> <span>{{ $activite->code }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Nom :</b> <span>{{ $activite->nom }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Description :</b> <span>{{ $activite->description ?? '-' }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Montant :</b> <span>{{ $activite->montant ?? '-' }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Date Début :</b> <span>{{ $activite->datedebut }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Date Fin :</b> <span>{{ $activite->datefin ?? 'En cours' }}</span></li>
                    <li class="list-group-item d-flex justify-content-between">
                        <b>Réalisation maximale :</b>
                        <button class="btn btn-sm btn-success" disabled>{{ $activite->over_taux ? 'plus de 100%' : '100%' }}</button>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <b>Actif :</b>
                        @if(!$activite->valide)
                            <button class="btn btn-sm {{ $activite->actif ? 'btn-success' : 'btn-secondary' }}" disabled>{{ $activite->actif ? 'OUI' : 'NON' }}</button>
                        @else
							@if(in_array($usergroupId, [1,2,4]))
								<a href="{{ route('activites.actif', $activite->id) }}" class="btn btn-sm {{ $activite->actif ? 'btn-success' : 'btn-secondary' }}">{{ $activite->actif ? 'OUI' : 'NON' }}</a>
							@else
								<button class="btn btn-sm {{ $activite->actif ? 'btn-success' : 'btn-secondary' }}" disabled>{{ $activite->actif ? 'OUI' : 'NON' }}</button>
							@endif
						@endif
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <b>Ouvert :</b>
                        @if(!$activite->actif)
                            <button class="btn btn-sm {{ $activite->ouvert ? 'btn-success' : 'btn-secondary' }}" disabled>{{ $activite->ouvert ? 'OUI' : 'NON' }}</button>
                        @else
							@if(in_array($usergroupId, [1,2,4]))
								<a href="{{ route('activites.ouvert', $activite->id) }}" class="btn btn-sm {{ $activite->ouvert ? 'btn-success' : 'btn-secondary' }}">{{ $activite->ouvert ? 'OUI' : 'NON' }}</a>
							@else
								<button class="btn btn-sm {{ $activite->ouvert ? 'btn-success' : 'btn-secondary' }}" disabled>{{ $activite->ouvert ? 'OUI' : 'NON' }}</button>
							@endif
						@endif
                    </li>
                </ul>
            </div>

            {{-- État de validation --}}
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>État de validation</u></h5>
                @if($usergroupId == 4)
                    <button class="btn btn-sm {{ $activite->valide ? 'btn-success' : 'btn-secondary' }}" disabled>{{ $activite->valide ? 'VALIDE' : 'NON VALIDE' }}</button>
                @else
                    <a href="{{ route('activites.valide', $activite->id) }}" class="btn btn-sm {{ $activite->valide ? 'btn-success' : 'btn-secondary' }}">{{ $activite->valide ? 'VALIDE' : 'NON VALIDE' }}</a>
                @endif
            </div>

            {{-- Informations liées --}}
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Informations liées</u></h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex justify-content-between"><b>Groupe d'activité :</b> <span>{{ $activite->groupeactivite->nom ?? '-' }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Action :</b> <span>{{ $activite->action->nom ?? '-' }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Résultat :</b> <span>{{ $activite->resultat->nom ?? '-' }}</span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Structure responsable :</b> <span>{{ $activite->structureresponsable->nom ?? '-' }}</span></li>
                </ul>
            </div>

            {{-- Extrants --}}
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Extrants</u></h5>
                @php $canAddExtrant = ($activite->ouvert && $activite->actif) || !$activite->valide; @endphp
                @if($canAddExtrant)
                    <a href="{{ route('extrants.create', ['activiteid' => $activite->id, 'activitestate' => $canAddExtrant]) }}" class="btn btn-danger mb-3 rounded-pill"><i class="bi bi-plus-circle"></i> Nouvel Extrant</a>
                @endif
                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Libellé</th>
                            <th>Début</th>
                            <th>Fin</th>
                            <th>Outils</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($activite->extrants as $extrant)
                        <tr>
                            <td>{{ $extrant->nom }}</td>
                            <td>{{ $extrant->debut }}</td>
                            <td>{{ $extrant->fin }}</td>
                            @if($canAddExtrant)
                                <td class="text-center">
                                    <a href="{{ route('extrants.edit', $extrant->id) }}" class="btn btn-warning btn-sm"><i class="bi bi-pen"></i></a>
                                    <a href="{{ route('extrants.destroy', $extrant->id) }}" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer ?')"><i class="bi bi-trash"></i></a>
                                </td>
                            @endif
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Étapes --}}
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Étapes</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Ordre</th>
                            <th>Nom</th>
                            <th>Pondération</th>
                            <th>Niveau exécution</th>
                            <th>Source de vérification</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($activite->etapes as $etape)
                        <tr>
                            <td>{{ $etape->ordre }}</td>
                            <td>{{ $etape->nom }}</td>
                            <td>{{ $etape->ponderation }} %</td>
                            <td>{{ $etape->niveauexec }} %</td>
                            <td>{{ $etape->sourceverif ?? '-' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Structures partenaires --}}
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Structures partenaires</u></h5>
                @php $canAddStructure = ($activite->ouvert && $activite->actif) || !$activite->valide; @endphp
                @if($canAddStructure)
                    <a href="{{ route('structures.selecforactivite', ['activiteid' => $activite->id, 'activitestate' => $canAddStructure]) }}" class="btn btn-danger mb-3 rounded-pill"><i class="bi bi-plus-circle"></i> Ajouter une structure</a>
                @endif
                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Structure</th>
                            <th>Ministère</th>
                            <th>Début</th>
                            <th>Fin</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($activite->structurespartenaires ?? [] as $structure)
                        <tr>
                            <td>{{ $structure->nom }} ({{ $structure->code }})</td>
                            <td>{{ $structure->ministere->nom ?? '-' }}</td>
                            <td>{{ $structure->pivot->datedebut ?? 'En cours' }}</td>
                            <td>{{ $structure->pivot->datefin ?? 'En cours' }}</td>
                            @if($canAddStructure)
                                <td class="text-center"><a href="{{ route('structureactivites.detach', $structure->pivot->id) }}" class="btn btn-danger btn-sm">X</a></td>
                            @endif
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Prévision / Évaluation --}}
			<div class="d-flex justify-content-center gap-3 mb-4">
				<a href="{{ route('activites.planning', ['id' => $activite->id]) }}" 
				   class="btn rounded-pill" 
				   style="background-color: #6c757d; color: white;">
					<i class="bi bi-plus-circle"></i> Prévision
				</a>
				<a href="{{ route('activites.evaluate', ['id' => $activite->id]) }}" 
				   class="btn rounded-pill" 
				   style="background-color: #0d6efd; color: white;">
					<i class="bi bi-clipboard-check"></i> Évaluation
				</a>
			</div>


            {{-- Historique anciens intervenants --}}
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Historique des anciens intervenants</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Structure</th>
                            <th>Ministère</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($activite->structurearchives ?? [] as $structureold)
                        <tr>
                            <td>{{ $structureold->nom }} ({{ $structureold->code }})</td>
                            <td>{{ $structureold->ministere->nom }} ({{ $structureold->ministere->code }})</td>
                            <td>{{ $structureold->pivot->datedebut }}</td>
                            <td>{{ $structureold->pivot->datefin }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</section>
@endsection
