@extends('layouts.app')
@section('title', 'Programme')

@section('content')

<div class="pagetitle">
    <h1>Détails du Programme</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ url('index.html') }}">Accueil</a></li>
            <li class="breadcrumb-item"><a href="{{ url('programmes') }}">Programmes</a></li>
            <li class="breadcrumb-item active">Détails</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm">
        <div class="card-body">

            {{-- Titre Programme --}}
            <h3 class="mb-4">Programme : <strong>{{ $programme->nom }}</strong></h3>

            {{-- Message Session --}}
            @if(Session::has('status'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ Session::get('status') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            @endif
			
			@php
				$usergroupId = Auth::user()->usergroup_id;
			@endphp

			{{-- Informations générales --}}
			<div class="row justify-content-start mb-4">
				<div class="col-md-9"> {{-- largeur 3/4 --}}
					<div class="callout callout-primary p-3 border border-primary rounded">
						<h5 class="mb-3 text-primary"><u>Informations générales</u></h5>
						<ul class="list-group list-group-flush">
							<li class="list-group-item d-flex justify-content-between">
								<b>Code :</b> <span>{{ $programme->code }}</span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Intitulé :</b> <span>{{ $programme->nom }}</span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Détails :</b> <span>{{ $programme->description }}</span>
							</li>

							{{-- Statut Actif --}}
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Programme activé :</b>
								<span>
									@if(in_array($usergroupId, [1,2,4]))
										<a href="{{ route('programmes.fonctactif', $programme->id) }}" class="btn btn-sm {{ $programme->actif ? 'btn-success' : 'btn-secondary' }}">
											{{ $programme->actif ? 'OUI' : 'NON' }}
										</a>
									@else
										<button class="btn btn-sm {{ $programme->actif ? 'btn-success' : 'btn-secondary' }}" disabled>
											{{ $programme->actif ? 'OUI' : 'NON' }}
										</button>
									@endif
								</span>
							</li>

							{{-- Statut Ouvert --}}
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Ouvert (en élaboration/revu) :</b>
								<span>
									@if(in_array($usergroupId, [1,2,4]))
										<a href="{{ route('programmes.fonctouvert', $programme->id) }}" class="btn btn-sm {{ $programme->ouvert ? 'btn-success' : 'btn-secondary' }}">
											{{ $programme->ouvert ? 'OUI' : 'NON' }}
										</a>
									@else
										<button class="btn btn-sm {{ $programme->ouvert ? 'btn-success' : 'btn-secondary' }}" disabled>
											{{ $programme->ouvert ? 'OUI' : 'NON' }}
										</button>
									@endif
								</span>
							</li>

							{{-- Responsable programme --}}
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Responsable programme :</b>
								<span>
									@if(in_array($usergroupId, [1,2]))
										@isset($programme->user)
											{{ $programme->user->name }} ({{ $programme->user->email }})
											<a href="{{ route('programmes.rpremove', $programme->id) }}" onclick="return confirm('Enlever ce RP ?')" class="text-danger ms-2">X</a>
										@else
											Non désigné
											<a href="{{ route('users.rpcreate', ['level' => 'program', 'id' => $programme->id]) }}" class="btn btn-warning btn-sm ms-2">
												<i class="bi bi-plus-circle"></i> Choisir/Modifier RP
											</a>
										@endisset
									@endif
								</span>
							</li>
						</ul>
					</div>
				</div>
			</div>


            {{-- Boutons globaux Programme --}}
            @if(in_array($usergroupId, [1,2]))
            <div class="mb-4">
				@if(!$programme->actif)
					<a href="{{ route('programmes.fonctallactif', $programme->id) }}" class="btn {{ $programme->actif ? 'btn-success' : 'btn-secondary' }} me-2">
						{{ $programme->actif ? 'Désactiver tout' : 'Activer tout' }}
					</a>
				@endif
				@if(!$programme->ouvert)
					<a href="{{ route('programmes.fonctallouvert', $programme->id) }}" class="btn {{ $programme->ouvert ? 'btn-success' : 'btn-secondary' }}">
						{{ $programme->ouvert ? 'Fermer tout' : 'Ouvrir tout' }}
					</a>
				@endif
            </div>
            @endif

            {{-- Liste des actions --}}
            <div class="callout callout-danger mb-4 p-3 border border-danger rounded">
                <h5 class="mb-3 text-danger"><u>Liste des actions</u></h5>

                @if(in_array($usergroupId, [1,2,4]) && $programme->actif && $programme->ouvert)
                    <a href="{{ route('actions.create', ['progid' => $programme->id]) }}" class="btn btn-primary mb-3">
                        <i class="bi bi-plus-circle"></i> Ajouter une action
                    </a>
                @endif

                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Code</th>
                            <th>Libellé</th>
                            <th>Actif</th>
                            <th>Ouvert</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($programme->actions ?? [] as $action)
                        <tr>
                            <td>{{ $action->code }}</td>
                            <td>{{ $action->nom }}</td>
                            <td class="text-center">
                                <a href="{{ route('actions.actif', $action->id) }}" class="btn btn-sm {{ $action->actif ? 'btn-success' : 'btn-secondary' }}">
                                    {{ $action->actif ? 'OUI' : 'NON' }}
                                </a>
                            </td>
                            <td class="text-center">
                                <a href="{{ route('actions.ouvert', $action->id) }}" class="btn btn-sm {{ $action->ouvert ? 'btn-success' : 'btn-secondary' }}">
                                    {{ $action->ouvert ? 'OUI' : 'NON' }}
                                </a>
                            </td>
                            <td class="text-center">
                                <a href="{{ route('actions.show', $action->id) }}" class="btn btn-info btn-sm"><i class="bi bi-eye"></i></a>
                                @if(in_array($usergroupId, [1,2,4]))
                                    <a href="{{ route('actions.edit', $action->id) }}" class="btn btn-warning btn-sm"><i class="bi bi-pen"></i></a>
                                    <a href="{{ route('actions.destroy', $action->id) }}" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer cette action ?')"><i class="bi bi-trash"></i></a>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            {{-- Historique des RPs --}}
            <div class="callout callout-info p-3 border border-info rounded">
                <h5 class="mb-3 text-info"><u>Historique des RPs</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-info text-center">
                        <tr>
                            <th>Responsable</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($programme->responsables ?? [] as $resp)
                        <tr>
                            <td>{{ $resp->user }}</td>
                            <td>{{ $resp->datedebut }}</td>
                            <td>{{ $resp->datefin ?? 'En cours' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</section>
@endsection
