<?php $__env->startSection('title', 'Evaluations'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h3>Tableau des évaluations</h3>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Evaluations</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <!-- Table with stripped rows -->
		
      <br/><button onclick="exportTableToExcel('evaluations-table', 'évaluations.xlsx', {includeColumns: [0,1,2,3,4,5,6,7]})" 
        class="btn btn-success">
    Exporter en Excel
</button>
			<table class="table datatable table-custom" id="evaluations-table">
					<thead class="table-dark">
						<tr>
							<th>Activité</th>
							<th>Extrant</th>
							<th>Période</th>
							<th>Prévision</th>
							<th>Réalisation</th>
							<th>Écart</th>
							<th>Commentaire</th>
							<th>Validée</th>
						</tr>
					</thead>
					<tbody>
						<?php $__currentLoopData = $evaluations->groupBy('activite_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activiteId => $activiteEvals): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<?php
								$activite = $activiteEvals->first()->activite;
								$extrantsGrouped = $activiteEvals->groupBy('extrant_id');
							?>
							<?php $__currentLoopData = $extrantsGrouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extrantId => $extrantEvals): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<?php
									$extrant = $extrantEvals->first()->extrant;
								?>
								<?php $__currentLoopData = $extrantEvals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $eval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<?php
										$tauxPrevision = $eval->taux_prevision ?? 0;
										$tauxRealisation = $eval->taux_realisation ?? 0;
										$eccart = $tauxRealisation - $tauxPrevision;
									?>
									<tr>
										
										<?php if($loop->first && $loop->parent->first): ?>
											<td rowspan="<?php echo e($extrantsGrouped->sum(fn($grp) => $grp->count())); ?>">
												<?php echo e($activite->nom); ?>

												<a href="<?php echo e(route('activites.planning', $activite->id)); ?>" class="btn btn-info btn-sm">
													<i class="bi bi-eye"></i>
												</a>
											</td>
										<?php endif; ?>

										
										<?php if($loop->first): ?>
											<td rowspan="<?php echo e($extrantEvals->count()); ?>">
												<?php echo e($extrant->nom); ?>

											</td>
										<?php endif; ?>

										
										<td><?php echo e($eval->date_reference); ?></td>
										<td><?php echo e($tauxPrevision); ?>%</td>
										<td><?php echo e($tauxRealisation); ?>%</td>
										<td>
											<?php if($eccart >= 0): ?>
												<span style="background-color: #b7eb8f; color: black; padding: 3px 6px; border-radius: 4px;">
													<?php echo e($eccart); ?>%
												</span>
											<?php else: ?>
												<span style="background-color: #f8b5b5; color: black; padding: 3px 6px; border-radius: 4px;">
													<?php echo e($eccart); ?>%
												</span>
											<?php endif; ?>
										</td>
										<td><?php echo e($eval->commentaire ?? '-'); ?></td>
										<td>
											<span class="badge <?php echo e($eval->valide ? 'bg-success' : 'bg-danger'); ?>">
												<?php echo e($eval->valide ? 'Oui' : 'Non'); ?>

											</span>
										</td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					</tbody>
				</table>

          <!-- End Table -->

        </div>
      </div>

    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/evaluations/index.blade.php ENDPATH**/ ?>