
<?php $__env->startSection('title', 'Activité'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h1>Détails Activité</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('actions.show', $activite->action_id)); ?>">Détails Action</a></li>
            <li class="breadcrumb-item active">Détails Activité</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm">
        <div class="card-body">
            <h3 class="text-danger mb-4">Activité : <strong><?php echo e($activite->nom); ?></strong></h3>

            
            <?php if(Session::has('status')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(Session::get('status')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php $usergroupId = Auth::user()->usergroup_id; ?>

            
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Informations générales</u></h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex justify-content-between"><b>Code :</b> <span><?php echo e($activite->code); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Nom :</b> <span><?php echo e($activite->nom); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Description :</b> <span><?php echo e($activite->description ?? '-'); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Montant :</b> <span><?php echo e($activite->montant ?? '-'); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Date Début :</b> <span><?php echo e($activite->datedebut); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Date Fin :</b> <span><?php echo e($activite->datefin ?? 'En cours'); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between">
                        <b>Réalisation maximale :</b>
                        <button class="btn btn-sm btn-success" disabled><?php echo e($activite->over_taux ? 'plus de 100%' : '100%'); ?></button>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <b>Actif :</b>
                        <?php if(!$activite->valide): ?>
                            <button class="btn btn-sm <?php echo e($activite->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled><?php echo e($activite->actif ? 'OUI' : 'NON'); ?></button>
                        <?php else: ?>
							<?php if(in_array($usergroupId, [1,2,4])): ?>
								<a href="<?php echo e(route('activites.actif', $activite->id)); ?>" class="btn btn-sm <?php echo e($activite->actif ? 'btn-success' : 'btn-secondary'); ?>"><?php echo e($activite->actif ? 'OUI' : 'NON'); ?></a>
							<?php else: ?>
								<button class="btn btn-sm <?php echo e($activite->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled><?php echo e($activite->actif ? 'OUI' : 'NON'); ?></button>
							<?php endif; ?>
						<?php endif; ?>
                    </li>
                    <li class="list-group-item d-flex justify-content-between">
                        <b>Ouvert :</b>
                        <?php if(!$activite->actif): ?>
                            <button class="btn btn-sm <?php echo e($activite->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled><?php echo e($activite->ouvert ? 'OUI' : 'NON'); ?></button>
                        <?php else: ?>
							<?php if(in_array($usergroupId, [1,2,4])): ?>
								<a href="<?php echo e(route('activites.ouvert', $activite->id)); ?>" class="btn btn-sm <?php echo e($activite->ouvert ? 'btn-success' : 'btn-secondary'); ?>"><?php echo e($activite->ouvert ? 'OUI' : 'NON'); ?></a>
							<?php else: ?>
								<button class="btn btn-sm <?php echo e($activite->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled><?php echo e($activite->ouvert ? 'OUI' : 'NON'); ?></button>
							<?php endif; ?>
						<?php endif; ?>
                    </li>
                </ul>
            </div>

            
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>État de validation</u></h5>
                <?php if($usergroupId == 4): ?>
                    <button class="btn btn-sm <?php echo e($activite->valide ? 'btn-success' : 'btn-secondary'); ?>" disabled><?php echo e($activite->valide ? 'VALIDE' : 'NON VALIDE'); ?></button>
                <?php else: ?>
                    <a href="<?php echo e(route('activites.valide', $activite->id)); ?>" class="btn btn-sm <?php echo e($activite->valide ? 'btn-success' : 'btn-secondary'); ?>"><?php echo e($activite->valide ? 'VALIDE' : 'NON VALIDE'); ?></a>
                <?php endif; ?>
            </div>

            
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Informations liées</u></h5>
                <ul class="list-group list-group-flush">
                    <li class="list-group-item d-flex justify-content-between"><b>Groupe d'activité :</b> <span><?php echo e($activite->groupeactivite->nom ?? '-'); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Action :</b> <span><?php echo e($activite->action->nom ?? '-'); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Résultat :</b> <span><?php echo e($activite->resultat->nom ?? '-'); ?></span></li>
                    <li class="list-group-item d-flex justify-content-between"><b>Structure responsable :</b> <span><?php echo e($activite->structureresponsable->nom ?? '-'); ?></span></li>
                </ul>
            </div>

            
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Extrants</u></h5>
                <?php $canAddExtrant = ($activite->ouvert && $activite->actif) || !$activite->valide; ?>
                <?php if($canAddExtrant): ?>
                    <a href="<?php echo e(route('extrants.create', ['activiteid' => $activite->id, 'activitestate' => $canAddExtrant])); ?>" class="btn btn-danger mb-3 rounded-pill"><i class="bi bi-plus-circle"></i> Nouvel Extrant</a>
                <?php endif; ?>
                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Libellé</th>
                            <th>Début</th>
                            <th>Fin</th>
                            <th>Outils</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $activite->extrants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extrant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($extrant->nom); ?></td>
                            <td><?php echo e($extrant->debut); ?></td>
                            <td><?php echo e($extrant->fin); ?></td>
                            <?php if($canAddExtrant): ?>
                                <td class="text-center">
                                    <a href="<?php echo e(route('extrants.edit', $extrant->id)); ?>" class="btn btn-warning btn-sm"><i class="bi bi-pen"></i></a>
                                    <a href="<?php echo e(route('extrants.destroy', $extrant->id)); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer ?')"><i class="bi bi-trash"></i></a>
                                </td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Étapes</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Ordre</th>
                            <th>Nom</th>
                            <th>Pondération</th>
                            <th>Niveau exécution</th>
                            <th>Source de vérification</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $activite->etapes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $etape): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($etape->ordre); ?></td>
                            <td><?php echo e($etape->nom); ?></td>
                            <td><?php echo e($etape->ponderation); ?> %</td>
                            <td><?php echo e($etape->niveauexec); ?> %</td>
                            <td><?php echo e($etape->sourceverif ?? '-'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Structures partenaires</u></h5>
                <?php $canAddStructure = ($activite->ouvert && $activite->actif) || !$activite->valide; ?>
                <?php if($canAddStructure): ?>
                    <a href="<?php echo e(route('structures.selecforactivite', ['activiteid' => $activite->id, 'activitestate' => $canAddStructure])); ?>" class="btn btn-danger mb-3 rounded-pill"><i class="bi bi-plus-circle"></i> Ajouter une structure</a>
                <?php endif; ?>
                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Structure</th>
                            <th>Ministère</th>
                            <th>Début</th>
                            <th>Fin</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $activite->structurespartenaires ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($structure->nom); ?> (<?php echo e($structure->code); ?>)</td>
                            <td><?php echo e($structure->ministere->nom ?? '-'); ?></td>
                            <td><?php echo e($structure->pivot->datedebut ?? 'En cours'); ?></td>
                            <td><?php echo e($structure->pivot->datefin ?? 'En cours'); ?></td>
                            <?php if($canAddStructure): ?>
                                <td class="text-center"><a href="<?php echo e(route('structureactivites.detach', $structure->pivot->id)); ?>" class="btn btn-danger btn-sm">X</a></td>
                            <?php endif; ?>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
			<div class="d-flex justify-content-center gap-3 mb-4">
				<a href="<?php echo e(route('activites.planning', ['id' => $activite->id])); ?>" 
				   class="btn rounded-pill" 
				   style="background-color: #6c757d; color: white;">
					<i class="bi bi-plus-circle"></i> Prévision
				</a>
				<a href="<?php echo e(route('activites.evaluate', ['id' => $activite->id])); ?>" 
				   class="btn rounded-pill" 
				   style="background-color: #0d6efd; color: white;">
					<i class="bi bi-clipboard-check"></i> Évaluation
				</a>
			</div>


            
            <div class="callout p-3 border border-danger rounded mb-4">
                <h5 class="text-danger mb-3"><u>Historique des anciens intervenants</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-danger text-center">
                        <tr>
                            <th>Structure</th>
                            <th>Ministère</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $activite->structurearchives ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structureold): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($structureold->nom); ?> (<?php echo e($structureold->code); ?>)</td>
                            <td><?php echo e($structureold->ministere->nom); ?> (<?php echo e($structureold->ministere->code); ?>)</td>
                            <td><?php echo e($structureold->pivot->datedebut); ?></td>
                            <td><?php echo e($structureold->pivot->datefin); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/activites/show.blade.php ENDPATH**/ ?>