<?php $__env->startSection('title', 'Action'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h1>Détails Action</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('programmes.show', $action->programme_id)); ?>">Détail programme</a></li>
            <li class="breadcrumb-item active">Détails action</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm">
        <div class="card-body">
            <h3 class="mb-4">Action : <strong><?php echo e($action->nom); ?></strong></h3>

            
            <?php if(Session::has('status')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(Session::get('status')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php
                $usergroupId = Auth::user()->usergroup_id;
            ?>

            
            <div class="row justify-content-start mb-4">
                <div class="col-md-9">
                    <div class="callout callout-primary p-3 border border-primary rounded">
                        <h5 class="mb-3 text-primary"><u>Informations générales</u></h5>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between">
                                <b>Code :</b> <span><?php echo e($action->code); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <b>Intitulé :</b> <span><?php echo e($action->nom); ?></span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between">
                                <b>Détails :</b> <span><?php echo e($action->description); ?></span>
                            </li>

                            
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <b>Action activée :</b>
                                <span>
                                    <?php if(in_array($usergroupId, [1,2,4])): ?>
                                        <a href="<?php echo e(route('actions.actif', $action->id)); ?>" class="btn btn-sm <?php echo e($action->actif ? 'btn-success' : 'btn-secondary'); ?>">
                                            <?php echo e($action->actif ? 'OUI' : 'NON'); ?>

                                        </a>
                                    <?php else: ?>
                                        <button class="btn btn-sm <?php echo e($action->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
                                            <?php echo e($action->actif ? 'OUI' : 'NON'); ?>

                                        </button>
                                    <?php endif; ?>
                                </span>
                            </li>

                            
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <b>Ouvert (en élaboration/revu) :</b>
                                <span>
                                    <?php if(in_array($usergroupId, [1,2,4])): ?>
                                        <a href="<?php echo e(route('actions.ouvert', $action->id)); ?>" class="btn btn-sm <?php echo e($action->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
                                            <?php echo e($action->ouvert ? 'OUI' : 'NON'); ?>

                                        </a>
                                    <?php else: ?>
                                        <button class="btn btn-sm <?php echo e($action->ouvert ? 'btn-success' : 'btn-secondary'); ?>" disabled>
                                            <?php echo e($action->ouvert ? 'OUI' : 'NON'); ?>

                                        </button>
                                    <?php endif; ?>
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
			
            <?php if(in_array($usergroupId, [1,2])): ?>
            <div class="mb-4">
				<?php if(!$action->actif): ?>
					<a href="<?php echo e(route('actions.actif', ['id' => $action->id, 'all' => true])); ?>" class="btn btn-sm <?php echo e($action->actif ? 'btn-success' : 'btn-secondary'); ?>">
						<?php echo e($action->actif ? 'Désactiver tout' : 'Activer tout'); ?>

					</a>
				<?php endif; ?>
				<?php if(!$action->ouvert): ?>
					<a href="<?php echo e(route('actions.ouvert', ['id' => $action->id, 'all' => true])); ?>" class="btn btn-sm <?php echo e($action->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
						<?php echo e($action->ouvert ? 'Fermer tout' : 'Ouvrir tout'); ?>

					</a>
				<?php endif; ?>
            </div>
            <?php endif; ?>

            
            <div class="callout callout-success mb-4 p-3 border border-success rounded">
                <h5 class="mb-3 text-success"><u>Résultats de l'action</u></h5>
<?php if(in_array($usergroupId, [1,2,4])): ?>
                <?php if($action->ouvert || !$action->actif): ?>
                    <a href="<?php echo e(route('resultats.create', ['actionid' => $action->id])); ?>" class="btn btn-primary mb-3">
                        <i class="bi bi-plus-circle"></i> Ajouter un résultat
                    </a>
                <?php endif; ?>
<?php endif; ?>

                <table class="table table-bordered table-striped">
                    <thead class="table-success text-center">
                        <tr>
                            <th>Libellé</th>
                            <th>Description</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $action->resultats ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resultat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($resultat->nom); ?></td>
                            <td><?php echo e($resultat->description); ?></td>
                            <td class="text-center">
                                <?php if($resultat->activites->isEmpty()): ?>
                                    <a href="<?php echo e(route('resultats.destroy', $resultat->id)); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer ce résultat ?')">
                                        <i class="bi bi-trash"></i>
                                    </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
				<div class="callout callout-danger mb-4 p-3 border border-danger rounded">
					<h5 class="mb-3 text-danger fw-bold"><u>Liste des activités par résultat</u></h5>
<?php if(in_array($usergroupId, [1,5,6])): ?>
					<?php if($action->ouvert || !$action->actif): ?>
						<a href="<?php echo e(route('activites.create', $action->id)); ?>" class="btn btn-primary mb-3">
							<i class="bi bi-plus-circle"></i> Ajouter une activité
						</a>
					<?php endif; ?>
<?php endif; ?>

					<?php $__empty_1 = true; $__currentLoopData = $action->resultats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resultat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
						<div class="mb-3">
							<h6 class="text-danger fw-bold"><i class="bi bi-chevron-right"></i> Résultat : <?php echo e($resultat->nom); ?></h6>

							<?php if($resultat->activites->isEmpty()): ?>
								<p class="text-muted">Aucune activité pour ce résultat.</p>
							<?php else: ?>
								<table class="table table-bordered table-striped">
									<thead class="table-danger text-center fw-bold">
										<tr>
											<th>Code</th>
											<th>Libellé</th>
											<th>Groupe d'activité</th>
											<th>Responsable</th>
											<th>Actif</th>
											<th>Ouvert</th>
											<th>Actions</th>
										</tr>
									</thead>
									<tbody>
										<?php $__currentLoopData = $resultat->activites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
										<tr>
											<td><?php echo e($activite->code); ?></td>
											<td><?php echo e($activite->nom); ?></td>
											<td><?php echo e($activite->groupeactivite->nom ?? '-'); ?></td>
											<td><?php echo e($activite->structureresponsable->nom ?? '-'); ?></td>
											<td class="text-center">
											
                        
                         <?php if(in_array($usergroupId, [3,4,6])): ?>
                <button class="btn-sm-status <?php echo e($activite->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
                  <?php echo e($a->actif ? 'OUI' : 'NON'); ?>

                </button>
              <?php endif; ?>
              <?php if(in_array($usergroupId, [1,2,5])): ?>
                	<a href="<?php echo e(route('activites.actif', $activite->id)); ?>" class="btn btn-sm <?php echo e($activite->actif ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($activite->actif ? 'OUI' : 'NON'); ?>

												</a>
              <?php endif; ?>
											</td>
											<td class="text-center">
												
                         <?php if(in_array($usergroupId, [3,4,5,6])): ?>
                <button class="btn-sm-status <?php echo e($activite->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
                  <?php echo e($a->ouvert ? 'Ouvert' : 'Fermé'); ?>

                </button>
              <?php endif; ?>
              <?php if(in_array($usergroupId, [1,2])): ?>
               <a href="<?php echo e(route('activites.ouvert', $activite->id)); ?>" class="btn btn-sm <?php echo e($activite->ouvert ? 'btn-success' : 'btn-secondary'); ?>">
													<?php echo e($activite->ouvert ? 'OUI' : 'NON'); ?>

												</a>
              <?php endif; ?>
											</td>
											<td class="text-center">
												<a href="<?php echo e(route('activites.show', $activite->id)); ?>" class="btn btn-info btn-sm"><i class="bi bi-eye"></i></a>
                      <?php if(in_array($usergroupId, [1,2])): ?>
												<?php if(!$activite->valide): ?>
													<a href="<?php echo e(route('activites.edit', $activite->id)); ?>" class="btn btn-warning btn-sm"><i class="bi bi-pen"></i></a>
													<a href="<?php echo e(route('activites.destroy', $activite->id)); ?>" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer cette activité ?')"><i class="bi bi-trash"></i></a>
												<?php endif; ?>
                      <?php endif; ?>
											</td>
										</tr>
										<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
									</tbody>
								</table>
							<?php endif; ?>
						</div>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
						<p class="text-muted">Aucun résultat associé à cette action.</p>
					<?php endif; ?>
				</div>



            
            <div class="callout callout-info mb-4 p-3 border border-info rounded">
                <h5 class="mb-3 text-info"><u>Liste des structures intervenant</u></h5>
  <?php if(in_array($usergroupId, [1,2,4])): ?>
                <?php
                    $canAddStructure = $action->ouvert || !$action->actif;
                ?>
                <?php if($canAddStructure): ?>
                    <a href="<?php echo e(route('structures.selecforaction', ['actionid' => $action->id, 'actionstate' => $canAddStructure])); ?>" class="btn btn-primary mb-3">
                        <i class="bi bi-plus-circle"></i> Ajouter une structure
                    </a>
                <?php endif; ?>
  <?php endif; ?>

                <table class="table table-bordered table-striped">
                    <thead class="table-info text-center">
                        <tr>
                            <th>Structure</th>
                            <th>Ministère</th>
                            <th>Du</th>
                            <th>Au</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $action->structures ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($structure->nom); ?> (<?php echo e($structure->code); ?>)</td>
                            <td><?php echo e($structure->ministere->nom); ?> (<?php echo e($structure->ministere->code); ?>)</td>
                            <td><?php echo e($structure->pivot->datedebut); ?></td>
                            <td><?php echo e($structure->pivot->datefin ?? 'En cours'); ?></td>
                            <td class="text-center">
                                <a href="<?php echo e(route('structureactions.detach', $structure->pivot->id)); ?>" class="btn btn-danger btn-sm">X</a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

            
            <div class="callout callout-secondary mb-4 p-3 border border-secondary rounded">
                <h5 class="mb-3 text-secondary"><u>Historique des anciens intervenants</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-secondary text-center">
                        <tr>
                            <th>Structure</th>
                            <th>Ministère</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $action->structurearchives ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structureold): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($structureold->nom); ?> (<?php echo e($structureold->code); ?>)</td>
                            <td><?php echo e($structureold->ministere->nom); ?> (<?php echo e($structureold->ministere->code); ?>)</td>
                            <td><?php echo e($structureold->pivot->datedebut); ?></td>
                            <td><?php echo e($structureold->pivot->datefin); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/actions/show.blade.php ENDPATH**/ ?>