<?php $__env->startSection('title', 'Activités'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Liste des Activités</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
      <li class="breadcrumb-item active">Activités</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="card">
    <div class="card-body">
      <h5 class="card-title">Toutes les activités</h5>

      <?php
        $usergroupId = Auth::user()->usergroup_id;
      ?>
      <?php if(!in_array($usergroupId , [3, 4, 5, 6])): ?>
        <a href="<?php echo e(route('activites.create')); ?>" class="btn btn-primary mb-3">Ajouter une activité</a>
      <?php endif; ?>

     
      <br/><button onclick="exportTableToExcel('activites-table', 'activites.xlsx', {includeColumns: [0,1,2,3,4,5,6]})" 
        class="btn btn-success">
    Exporter en Excel
</button>

      <table class="table datatable table-custom" id="activites-table">
        <thead>
          <tr>
            <th style="min-width: 250px;">Code & Nom</th>
            <th>Groupe</th>
            <th>Action</th>
            <th>Responsable</th>
            <th>Montant</th>
            <th>Actif</th>
            <th>Ouvert</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $activites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($a->code); ?> : <?php echo e($a->nom); ?></td>
            <td><?php echo e($a->groupeactivite->nom ?? '-'); ?></td>
            <td><?php echo e($a->action->nom ?? '-'); ?></td>
            <td><?php echo e($a->structureresponsable->nom ?? '-'); ?></td>
            <td style="white-space: nowrap;"><?php echo e($a->montant ? number_format($a->montant, 0, '', ' ') : '-'); ?></td>

            
            <td>
              <?php if(in_array($usergroupId, [3,4,6])): ?>
                <button class="btn-sm-status <?php echo e($a->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
                  <?php echo e($a->actif ? 'Oui' : 'Non'); ?>

                </button>
              <?php endif; ?>
              <?php if(in_array($usergroupId, [1,2,5])): ?>
                <a href="<?php echo e(route('activites.actif', $a->id)); ?>" 
                   class="btn-sm-status <?php echo e($a->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>">
                  <?php echo e($a->actif ? 'Oui' : 'Non'); ?>

                </a>
              <?php endif; ?>
            </td>

            
            <td>
              <?php if(in_array($usergroupId, [3,4,5,6])): ?>
                <button class="btn-sm-status <?php echo e($a->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
                  <?php echo e($a->ouvert ? 'Ouvert' : 'Fermé'); ?>

                </button>
              <?php endif; ?>
              <?php if(in_array($usergroupId, [1,2])): ?>
                <a href="<?php echo e(route('activites.ouvert', $a->id)); ?>" 
                   class="btn-sm-status <?php echo e($a->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>">
                  <?php echo e($a->ouvert ? 'Ouvert' : 'Fermé'); ?>

                </a>
              <?php endif; ?>
            </td>

            
            <td>
              <a href="<?php echo e(route('activites.show', $a->id)); ?>" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>
              <?php if(!in_array($usergroupId, [3,4,5,6])): ?>
                <?php if(!$a->valide): ?>
                  <a href="<?php echo e(route('activites.edit', $a->id)); ?>" class="btn-sm-status btn-sm-status-warning"><i class="bi bi-pen"></i></a>
                  <?php if(in_array($usergroupId, [1,2])): ?>
                    <a href="<?php echo e(route('activites.destroy', $a->id)); ?>" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer cette activité ?')"><i class="bi bi-trash"></i></a>
                  <?php endif; ?>
                <?php endif; ?>
              <?php endif; ?>
            </td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>

    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/activites/index.blade.php ENDPATH**/ ?>