<?php

namespace App\Http\Controllers;

use App\Models\Action;
use App\Models\Activite;
use Illuminate\Http\Request;
use App\Models\Programme;
use Illuminate\Support\Facades\Auth;

class ActionsController extends Controller
{
   
    public function index()
    {
		/*$actions = Action::with(['programme'])->orderBy('code')->get();
        return view('actions.index', compact('actions')); */
        try {
        $user = Auth::user();
           $groupId = $user->usergroup_id;
           if ($groupId == 4) {
                $actions = Action::whereHas('programme.responsables', function ($query) use ($user) {
                          $query->where('user_id', $user->id);
                            })
                            ->with('programme')
                            ->orderBy('code')
                            ->get();
            } 
            elseif ($groupId == 5 || $groupId == 4) {
                $actions = Action::select('actions.*')
                                ->join('programmes', 'programmes.id', '=', 'actions.programme_id')
                                ->join('structure_action', 'structure_action.action_id', '=', 'actions.id')
                                ->join('structures', 'structures.id', '=', 'structure_action.structure_id')
                                ->where('structures.responsablestructure_id', $user->id)
                                ->with(['programme'])
                                ->distinct()
                                ->orderBy('actions.code', 'asc')
                                ->get();
            }
			elseif ($groupId == 6) {
                $actions = Action::select('actions.*')
                                ->join('programmes', 'programmes.id', '=', 'actions.programme_id')
                                ->join('structure_action', 'structure_action.action_id', '=', 'actions.id')
                                ->join('structures', 'structures.id', '=', 'structure_action.structure_id')
                                ->where('structures.pointfocal_id', $user->id)
                                ->with(['programme'])
                                ->distinct()
                                ->orderBy('actions.code', 'asc')
                                ->get();
            }
            else {
              $actions = Action::with(['programme'])->orderBy('code')->get();
            }
            return view('actions.index', compact('actions'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des actions : ' . $e->getMessage());
        }
    }


 public function create($progid=null)
    {
		/*if(isset($progid)){
			$programme = Programme::select('ouvert', 'actif')->findOrFail($progid);
			if(!$programme->ouvert){
				return redirect()->back()->with('error', 'Impossible d\'ajouter des actions à un programme fermé');
			}
			if(!$programme->actif){
				return redirect()->back()->with('error', 'Impossible, demandez l\'activation du programme');
			}
		}
		$programmes = Programme::where('actif', true)->where('ouvert',true)->orderBy('code')->get();
        return view('actions.create', compact('programmes', 'progid'));*/
        try {
            if (isset($progid)) {
                $programme = Programme::select('ouvert', 'actif')->findOrFail($progid);

                if (!$programme->ouvert) {
                    return redirect()->back()->with('error', 'Impossible d’ajouter des actions à un programme fermé.');
                }

                if (!$programme->actif) {
                    return redirect()->back()->with('error', 'Impossible, demandez d’abord l’activation du programme.');
                }
            }

            $programmes = Programme::where('actif', true)
                ->where('ouvert', true)
                ->orderBy('code')
                ->get();

            return view('actions.create', compact('programmes', 'progid'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’ouverture du formulaire : ' . $e->getMessage());
        }
    }
  public function store(Request $request)
    {
        $request->validate([
            'programme_id' => 'required|exists:programmes,id',
            'code' => 'required|max:20|unique:actions,code',
            'nom' => 'required|max:100|unique:actions,nom',
        ]);

        /*Action::create($request->all());

        return redirect()->route('programmes.show', $request->programme_id)->with('success', 'Action ajoutée avec succès.');*/
        
		//return redirect()->back()->with('success', 'Action ajoutée avec succès.');
     try {
            $action = new Action($request->all());

            if ($action->save()) {
                return redirect()->route('programmes.show', $request->programme_id)
                    ->with('success', 'Action ajoutée avec succès.');
            } else {
                return redirect()->route('actions.index')
                    ->with('error', 'Échec de l’enregistrement de l’action.');
            }
        } catch (\Exception $e) {
            return redirect()->route('actions.index')
                ->with('error', 'Erreur inattendue lors de l’enregistrement : ' . $e->getMessage());
        }
   
    }

    public function show($id)
    {
       /* $action = Action::with(['programme', 'structures', 'activites', 'resultats', 'structurearchives'])->findOrFail($id);
		//dd($action); die();
        return view('actions.show', compact('action'));*/
         try {
            $action = Action::with(['programme', 'structures', 'activites', 'resultats', 'structurearchives'])
                ->findOrFail($id);

            return view('actions.show', compact('action'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’affichage de l’action : ' . $e->getMessage());
        }
    }

    public function edit($id)
    {
	   /* $action = Action::findOrFail($id);
	    if(!$action->ouvert){
		 return redirect()->back()->with('error', 'Impossible, l\'action n\'est pas ouvert actuellement aux révisions');
	    }
        $programmes = Programme::all();
        return view('actions.edit', compact('action', 'programmes'));*/
        try {
            $action = Action::findOrFail($id);

            if (!$action->ouvert) {
                return redirect()->back()->with('error', 'Impossible, l’action n’est pas ouverte actuellement aux révisions.');
            }

            $programmes = Programme::all();
            return view('actions.edit', compact('action', 'programmes'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’ouverture du formulaire d’édition : ' . $e->getMessage());
        }
    }

    public function update(Request $request, $id)
    {
	    $action = Action::findOrFail($id);

	    if(!$action->ouvert){
		 return redirect()->back()->with('error', 'Impossible, l\'action n\'est pas ouvert actuellement aux révisions');
	    }
        $request->validate([
            'programme_id' => 'required|exists:programmes,id',
            'code' => 'required|max:20|unique:actions,code,' . $id,
            'nom' => 'required|max:100|unique:actions,nom,' . $id,
        ]);

        /*$action->update($request->all());

        return redirect()->route('actions.index')->with('success', 'Action mise à jour avec succès.');*/
        try {
            $updated = $action->update($request->all());

            if ($updated) {
                return redirect()->route('actions.index')
                    ->with('success', 'Action mise à jour avec succès.');
            } else {
                return redirect()->route('actions.index')
                    ->with('error', 'Échec de la mise à jour de l’action.');
            }
        } catch (\Exception $e) {
            return redirect()->route('actions.index')
                ->with('error', 'Erreur inattendue lors de la mise à jour : ' . $e->getMessage());
        }
        
    }

    public function destroy($id)
    {
        $action = Action::with('activites', 'structures')->findOrFail($id);
		$progid = $action->programme_id;
		
		if($action->activites->isNotEmpty()){
			//dd('activités'); die();
			return redirect()->route('programmes.show', $progid)->with('error', 'Cette action contient des activités');
		}
		if($action->structures->isNotEmpty()){
			//dd('structures'); die();
			return redirect()->route('programmes.show', $progid)->with('error', 'Veuillez enlever les structures intervenant');
		}
		if($action->actif || $action->ouvert){
			//dd('actif ou ouvert'); die();
			return redirect()->route('programmes.show', $progid)->with('error', 'Assurez vous que l\'action et fermée et désactivée');
		}
		//dd($action); die();
		/*try {
			$action->resultats()->delete();
			$action->delete();
			return redirect()->route('programmes.show', $progid)->with('success', 'Action supprimée avec succès.');
		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}*/
    try {
            $action->resultats()->delete();

            if ($action->delete()) {
                return redirect()->route('programmes.show', $progid)->with('success', 'Action supprimée avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la suppression de l’action.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue lors de la suppression : ' . $e->getMessage());
        }
   
    }

    
    public function actif($id, $all=false)
    {
		$action = Action::findOrFail($id);
		$progactif = Programme::select('actif')->findOrFail($action->programme_id);
		$out = 'Non effectué. Vérifiez que le programme est actif.';
		try {
            if ($progactif->actif) {
                $newstate = !$action->actif;
                $action->actif = $newstate;

                if ($action->save()) {
                    if (!$newstate) {
                        $action->ouvert = false;
                        $action->save();
                        Activite::where('action_id', $id)->update(['actif' => false, 'ouvert' => false]);
                    }else{
						if($all){
							Activite::where('action_id', $id)->update(['actif' => $newstate]);
						}
					}
                    $out = 'Statut d’activation mis à jour avec succès.';
                } else {
                    $out = 'Échec de la mise à jour du statut.';
                }
            }
        } catch (\Exception $e) {
            return back()->with('error', 'Erreur inattendue lors du changement de statut : ' . $e->getMessage());
        }

        return back()->with('success', $out);
    }

    
    public function ouvert($id, $all=false)
    {
        $action = Action::findOrFail($id);
		$progouvert = Programme::select('ouvert')->findOrFail($action->programme_id);
		$out = 'Non effectué. Vérifiez que le programme est ouvert.';
		try {
            //if ($progouvert->ouvert) {
                $newstate = !$action->ouvert;

                if ($newstate && !$action->actif) {
                    return redirect()->back()->with('error', 'Impossible, activez d\'abord l’action.');
                }

                $action->ouvert = $newstate;

                if ($action->save()) {
					if(!$all){
						if (!$newstate) {
							Activite::where('action_id', $id)->update(['ouvert' => false]);
						}
					}else{
						Activite::where('action_id', $id)->update(['ouvert' => $newstate]);
					}
                    $out = 'Statut d’ouverture mis à jour avec succès.';
                } else {
                    $out = 'Échec de la mise à jour du statut d’ouverture.';
                }
           // }
        } catch (\Exception $e) {
            return back()->with('error', 'Erreur inattendue lors de la mise à jour : ' . $e->getMessage());
        }

        return back()->with('success', $out);
    }
    
}
