<?php

namespace App\Http\Controllers;

use App\Models\Csd;
use Illuminate\Http\Request;

class CsdsController extends Controller
{
    public function index()
    {
        try {
            $csds = Csd::orderBy('code')->get();
            return view('csds.index', compact('csds'));
        } catch (\Exception $e) {
            return back()->with('error', 'Erreur lors du chargement des CSD : ' . $e->getMessage());
        }
    }

    public function create()
    {
        try {
            return view('csds.create');
        } catch (\Exception $e) {
            return back()->with('error', 'Erreur lors de l’ouverture du formulaire : ' . $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        $request->validate([
            'code' => 'required|string|max:20|unique:csds,code',
            'nom' => 'required|string|max:100',
            'description' => 'nullable|string',
        ]);

        try {
            $csd = new Csd($request->all());

            if ($csd->save()) {
                return redirect()->route('csds.index')->with('success', 'CSD ajouté avec succès.');
            } else {
                return back()->with('error', 'Échec de l’enregistrement du CSD.');
            }
        } catch (\Exception $e) {
            return back()->with('error', 'Erreur inattendue lors de l’enregistrement : ' . $e->getMessage());
        }
    }

    public function edit($id)
    {
        try {
            $csd = Csd::findOrFail($id);
            return view('csds.edit', compact('csd'));
        } catch (\Exception $e) {
            return back()->with('error', 'Erreur lors du chargement du CSD : ' . $e->getMessage());
        }
    }

    public function update(Request $request, $id)
    {
        $request->validate([
            'code' => 'required|string|max:50|unique:csds,code,' . $id,
            'nom' => 'required|string|max:150',
            'description' => 'nullable|string',
        ]);

        try {
            $csd = Csd::findOrFail($id);
            $updated = $csd->update($request->all());

            if ($updated) {
                return redirect()->route('csds.index')->with('success', 'CSD modifié avec succès.');
            } else {
                return back()->with('error', 'Échec de la mise à jour du CSD.');
            }
        } catch (\Exception $e) {
            return back()->with('error', 'Erreur inattendue lors de la mise à jour : ' . $e->getMessage());
        }
    }

    public function destroy($id)
    {
        try {
            $csd = Csd::findOrFail($id);

            if ($csd->delete()) {
                return redirect()->route('csds.index')->with('success', 'CSD supprimé avec succès.');
            } else {
                return back()->with('error', 'Échec de la suppression du CSD.');
            }
        } catch (\Exception $e) {
            return back()->with('error', 'Erreur inattendue lors de la suppression : ' . $e->getMessage());
        }
    }
}
