<?php

namespace App\Http\Controllers;

use App\Models\FinancementActivite;
use Illuminate\Http\Request;

class FinancementActivitesController extends Controller
{
    public function index() { 
	return FinancementActivite::all(); }
    public function show($id) { 
	return FinancementActivite::findOrFail($id); }

    public function store(Request $request)
    {
        $data = $request->validate([
            'partenaire_id' => 'required|integer',
            'activite_id' => 'required|integer',
            'montant' => 'required|numeric',
        ]);
        return FinancementActivite::create($data);
    }

    public function update(Request $request, $id)
    {
        $f = FinancementActivite::findOrFail($id);
        $data = $request->validate([
            'partenaire_id' => 'sometimes|integer',
            'activite_id' => 'sometimes|integer',
            'montant' => 'sometimes|numeric',
        ]);
        $f->update($data);
        return $f;
    }

    public function destroy($id) {
	 FinancementActivite::findOrFail($id)->delete(); 
	return response()->json(['message'=>'Financement supprimé']); }
}
