<?php

namespace App\Http\Controllers;

use App\Models\Activite;
use App\Models\GroupeActivite;
use App\Models\Csd;
use Illuminate\Http\Request;

class GroupeActivitesController extends Controller
{
    public function index()
    {
        /*$groupeactivites = GroupeActivite::orderBy('code')->get();
        return view('groupeactivites.index', compact('groupeactivites'));*/
        try {
            $groupeactivites = GroupeActivite::orderBy('code')->get();
            return view('groupeactivites.index', compact('groupeactivites'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement de la liste des groupes d’activités : ' . $e->getMessage());
        }
    }
	
	public function show($id)
    {
        /*$groupeactivite = GroupeActivite::with(['etapes', 'csd'])->findOrFail($id);
		$nbractivites = Activite::where('groupe_id', $id)->where('valide', true)->count();
		return view('groupeactivites.show', compact('groupeactivite', 'nbractivites'));*/
    try {
            $groupeactivite = GroupeActivite::with(['etapes', 'csd'])->findOrFail($id);
            $nbractivites = Activite::where('groupe_id', $id)->where('valide', true)->count();

            return view('groupeactivites.show', compact('groupeactivite', 'nbractivites'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’affichage du groupe d’activités : ' . $e->getMessage());
        }
    }

    public function create()
    {
		/*$csds = Csd::all();
		return view('groupeactivites.create', compact('csds'));*/
    try {
            $csds = Csd::all();
            return view('groupeactivites.create', compact('csds'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire de création : ' . $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:groupeactivites,code',
            'nom' => 'required|string|max:100',
			'csd_id' => 'required|integer',
            'description' => 'nullable|string',
        ]);

      /*  GroupeActivite::create($validated);

        return redirect()->route('groupeactivites.index')->with('success', 'Groupe d’activité ajouté avec succès.');*/
        
         try {
         
            $groupeactivite = new GroupeActivite($validated);

            if ($groupeactivite->save()) {
                return redirect()->route('groupeactivites.index')
                    ->with('success', 'Groupe d’activité ajouté avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de l’ajout du groupe d’activités.');
            }

        }  catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue lors de l’ajout : ' . $e->getMessage());
        }
    }

  public function edit($id)
    {
       /* $groupeactivite = GroupeActivite::findOrFail($id);
		$csds = Csd::all();
        return view('groupeactivites.edit', compact('groupeactivite', 'csds'));*/
        
         try {
            $groupeactivite = GroupeActivite::findOrFail($id);
            $csds = Csd::all();
            return view('groupeactivites.edit', compact('groupeactivite', 'csds'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire d’édition : ' . $e->getMessage());
        }
    }

    public function update(Request $request, $id)
    {
        $groupeactivite = GroupeActivite::findOrFail($id);

        $validated = $request->validate([
            'code' => 'required|string|max:50|unique:groupeactivites,code,' . $groupeactivite->id,
            'nom' => 'required|string|max:150',
			'csd_id' => 'required|integer',
            'description' => 'nullable|string',
        ]);

        /*$groupeactivite->update($validated);

        return redirect()->route('groupeactivites.index')->with('success', 'Groupe d’activités modifié avec succès.');*/
        
        try {
          

   

            if ($groupeactivite->update($validated)) {
               

                return redirect()->route('groupeactivites.index')
                    ->with('success', 'Groupe d’activités modifié avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour du groupe d’activités.');
            }

        }  catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    public function destroy($id)
    {
		
		try {
			$groupeactivite = GroupeActivite::findOrFail($id);
			$groupeactivite->delete();
			return redirect()->route('groupeactivites.index')->with('success', 'Type d’activités supprimé avec succès.');

		} catch (\Exception $e) {
			// On récupère le message défini dans le modèle
			return redirect()->back()->with('error', $e->getMessage());
		}
		
        //return redirect()->route('groupeactivites.index')->with('success', 'Groupe d’activités supprimé avec succès.');
    }
	
	public function actif($id)
    {
       /* $groupeactivite = GroupeActivite::findOrFail($id);
		$groupeactivite->is_active = !$groupeactivite->is_active;
		$groupeactivite->save();

        return redirect()->back()->with('success');*/
        
        try {
            $groupeactivite = GroupeActivite::findOrFail($id);
            $groupeactivite->is_active = !$groupeactivite->is_active;

            if ($groupeactivite->save()) {
                return redirect()->back()->with('success', 'État du groupe d’activités mis à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour de l’état.');
            }

        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la modification de l’état : ' . $e->getMessage());
        }
    }
}
