<?php

namespace App\Http\Controllers;

use App\Models\Structure;
use App\Models\Ministere;
use App\Models\StructureAction;
use App\Models\ResponsableStructure;
use App\Models\Pointfocal;
use App\Models\User;
use Illuminate\Http\Request;

class StructuresController extends Controller
{
    public function index()
    {
		/*$structures = Structure::with(['ministere'])->get();
		return view('structures.index', compact('structures'));*/
    try {
            $structures = Structure::with('ministere')->get();
            return view('structures.index', compact('structures'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des structures : ' . $e->getMessage());
        }
    }

    public function create()
    {
        /*$ministeres = Ministere::all();
        return view('structures.create', compact('ministeres'));*/
        try {
            $ministeres = Ministere::all();
            return view('structures.create', compact('ministeres'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire : ' . $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:structures,code',
            'nom' => 'required|string|max:100',
            'description' => 'nullable|string',
            'ministere_id' => 'required|exists:ministeres,id',
        ]);

      /*  Structure::create($validated);

        return redirect()->route('structures.index')->with('success', 'Structure ajoutée avec succès.');*/
        
      

        try {
            $structure = new Structure($validated);
            if ($structure->save()) {
                return redirect()->route('structures.index')->with('success', 'Structure ajoutée avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de l’ajout de la structure.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’ajout de la structure : ' . $e->getMessage());
        }
    }

public function edit($id = 0)
    {  /* $structure = Structure::find($id);
        $ministeres = Ministere::all();
        return view('structures.edit', compact('structure', 'ministeres'));*/
        
         try {
            $structure = Structure::findOrFail($id);
            $ministeres = Ministere::all();
            return view('structures.edit', compact('structure', 'ministeres'));
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('structures.index')->with('error', 'Structure introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire : ' . $e->getMessage());
        }
    }

 public function update(Request $request, $id =0)
    {
	$structure = Structure::findOrFail($id);
        $validated = $request->validate([
            'code' => 'required|string|max:20|unique:structures,code,' . $structure->id,
            'nom' => 'required|string|max:100',
            'description' => 'nullable|string',
            'ministere_id' => 'required|exists:ministeres,id',
        ]);

      /*  $structure->update($validated);

        return redirect()->route('structures.index')->with('success', 'Structure mise à jour avec succès.');*/
        
        try {
           

            if ($structure->update($validated)) {
                return redirect()->route('structures.index')->with('success', 'Structure mise à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour de la structure.');
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return redirect()->back()->withErrors($e->validator)->withInput();
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('structures.index')->with('error', 'Structure introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la mise à jour : ' . $e->getMessage());
        }
    }


    public function destroy($id)
    { /*$structure =Structure::findOrFail($id);

        $structure->delete();
        return redirect()->route('structures.index')->with('success', 'Structure supprimée avec succès.');*/
        
         try {
            $structure = Structure::findOrFail($id);
            if ($structure->delete()) {
                return redirect()->route('structures.index')->with('success', 'Structure supprimée avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la suppression de la structure.');
            }
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('structures.index')->with('error', 'Structure introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la suppression : ' . $e->getMessage());
        }
    }
	
	
	public function show($id)
    {
        
         try {
            $structure = Structure::with('responsable', 'pointfocal', 'responsablearchives', 'pointfocalarchives', )->findOrFail($id);
            $structure->refresh();
            return view('structures.show', compact('structure'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’affichage de la structure : ' . $e->getMessage());
        }
    }

	
	public function selecforaction($actionid, $actionstate)
    {
    
       try {
            if (!$actionstate) {
                return redirect()->route('actions.show', $actionid)
                                 ->with('error', 'L\'action doit être activée et ouverte aux modifications.');
            }

            $structures = Structure::with('ministere')
                ->whereDoesntHave('actions', function ($query) use ($actionid) {
                    $query->where('actions.id', $actionid)
                          ->where('structure_action.is_active', true);
                })->get();

            return view('structures.addtoaction', compact('structures', 'actionid', 'actionstate'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des structures : ' . $e->getMessage());
        }
    }
	
	public function selecforactivite($activiteid, $activestate)
	{

		try {
            if (!$activestate) {
                return redirect()->route('activites.show', $activiteid)
                                 ->with('error', "L'activité doit être activée et ouverte aux modifications.");
            }

            $structures = Structure::with('ministere')
                ->whereDoesntHave('activitespartenaires', function ($query) use ($activiteid) {
                    $query->where('activites.id', $activiteid)
                          ->where('structure_activite.is_active', true);
                })->get();

            return view('structures.addtoactivite', compact('structures', 'activiteid', 'activestate'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des structures : ' . $e->getMessage());
        }
    }
	
	public function rsremove($id)
    {
    try {
            $structure = Structure::findOrFail($id);
            $structure->responsablestructure_id = null;

            if ($structure->save()) {
                $respstructure = ResponsableStructure::where('structure_id', $id)->orderBy('id', 'desc')->first();

                if ($respstructure) {
                    $respstructure->datefin = now();
                    $respstructure->save();

                    $user = User::find($respstructure->user_id);
                    if ($user) {
                        $user->is_rs = false;
                        $user->save();
                    }
                }
                return redirect()->back()->with('success', 'Responsable de structure retiré avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec du retrait du responsable.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }
	
	public function pfremove($id)
    {
    try {
            $structure = Structure::findOrFail($id);
            $structure->pointfocal_id = null;

            if ($structure->save()) {
                $pf = Pointfocal::where('structure_id', $id)->orderBy('id', 'desc')->first();

                if ($pf) {
                    $pf->datefin = now();
                    $pf->save();

                    $user = User::find($pf->user_id);
                    if ($user) {
                        $user->is_pf = false;
                        $user->save();
                    }
                }
                return redirect()->back()->with('success', 'Point focal retiré avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec du retrait du point focal.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }
	
	public function fonctactif($id)
    {
    try {
            $structure = Structure::findOrFail($id);
            $newstate = !$structure->actif;
            $structure->actif = $newstate;
            $structure->save();
            return redirect()->back()->with('success', 'État de la structure mis à jour avec succès.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la mise à jour de l’état de la structure : ' . $e->getMessage());
        }
    }
}
