<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Etape extends Model
{
    use HasFactory;

    protected $table = 'etapes';
    protected $primaryKey = 'id';

    protected $fillable = [
        'groupeactivite_id',
        'ordre',
        'nom',
        'ponderation',
        'niveauexec',
        'sourceverif',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    // Relation avec ModeleActivite
    public function groupeactivite()
    {
        return $this->belongsTo(GroupeActivite::class, 'groupeactivide_id', 'id');
    }

    // Relation avec Evaluations
    public function evaluations()
    {
        return $this->hasMany(Evaluation::class, 'etape_id', 'id');
    }
}
