<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ministere extends Model
{
    use HasFactory;

    protected $table = 'ministeres';
    protected $primaryKey = 'id';

    protected $fillable = [
        'code',
        'nom',
        'description',
        'created_at',
        'updated_at',
    ];

    public $timestamps = true;
	
	protected static function boot()
    {
        parent::boot();

        static::deleting(function ($groupe) {
            if ($groupe->structures()->exists()) {
                throw new \Exception("Suppression impossible : enlevez ses structures d'abord avant suppression d'un ministère");
            }
        });
    }

    // Relation avec Structures
    public function structures()
    {
        return $this->hasMany(Structure::class, 'ministere_id', 'id');
    }
}
