<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StructureAction extends Model
{
    use HasFactory;

    protected $table = 'structure_action';
    protected $primaryKey = 'id';

    protected $fillable = [
        'action_id',
        'structure_id',
        'created_at',
        'updated_at',
    ];

    public $timestamps = false;

    public function action()
    {
        return $this->belongsTo(Action::class, 'action_id', 'id');
    }

    public function structure()
    {
        return $this->belongsTo(Structure::class, 'structure_id', 'id');
    }
}
