<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Activite;

class ActiviteSeeder extends Seeder
{
    public function run(): void
    {
        $activites = [
            [
                'code' => 'AT1',
                'nom' => 'Campagne de sensibilisation',
                'datedebut' => '2025-01-10',
                'datefin' => '2025-02-10',
                'montant' => 1500000,
                'structure_id' => 1,
                'action_id' => 1,
                'valide' => true,
                'prog_actif' => true,
                'prog_ouvert' => true,
            ],
            [
                'code' => 'AT2',
                'nom' => 'Formation des agents régionaux',
                'datedebut' => '2025-03-01',
                'datefin' => '2025-03-15',
                'montant' => 800000,
                'structure_id' => 2,
                'action_id' => 1,
                'valide' => false,
                'prog_actif' => true,
                'prog_ouvert' => false,
            ],
        ];

        foreach ($activites as $a) {
            Activite::create($a);
        }
    }
}

