<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\TypePartenaire;

class TypePartenaireSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $typesPartenaires = [
            [
                'type' => 'Institution publique',
                'description' => 'Partenaire institutionnel appartenant à l’administration publique.',
            ],
            [
                'type' => 'Organisation internationale',
                'description' => 'Partenaire provenant d’organismes internationaux ou régionaux.',
            ],
            [
                'type' => 'Entreprise privée',
                'description' => 'Partenaire du secteur privé apportant un soutien technique ou financier.',
            ],
            [
                'type' => 'ONG / Association',
                'description' => 'Partenaire issu du milieu associatif ou non gouvernemental.',
            ],
            [
                'type' => 'Bailleur de fonds',
                'description' => 'Partenaire contribuant au financement de projets ou programmes.',
            ],
        ];

        foreach ($typesPartenaires as $type) {
            TypePartenaire::create($type);
        }
    }
}
