@extends('layouts.app')

@section('title', 'Groupe Activité')

@section('content')
 <div class="pagetitle">
      <h1>Ajout d'un Groupe d\'activité</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
          <li class="breadcrumb-item">Groupe Activité</li>
          <li class="breadcrumb-item active">Ajout</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <section class="section">
      <div class="row">
        <div class="col-lg-12">
 <div class="card">
  <div class="card-body">
    <h5 class="card-title">Ajouter un groupe d’activité</h5>

    <form method="POST" action="{{ route('groupeactivites.store') }}">
      @csrf
	  <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">CSD</label>
			<select name="csd_id" class="form-control" required>
                  <option value="">-- Choisir --</option>
                  @foreach($csds as $csd)
                    <option value="{{ $csd->id }}" {{ old('csd_id') == $csd->id ? 'selected' : '' }}>
					{{ $csd->nom }}</option>
                  @endforeach
            </select>
        </div>
	  </div>
      <div class="row g-3">
        <div class="col-md-6">
          <label class="form-label">Code</label>
          <input type="text" name="code" class="form-control" value="{{ old('code') }}" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Nom</label>
          <input type="text" name="nom" class="form-control" value="{{ old('nom') }}" required>
        </div>

        <div class="col-12">
          <label class="form-label">Description</label>
          <textarea name="description" class="form-control">{{ old('description') }}</textarea>
        </div>
      </div>

      <div class="mt-3">
        <button type="submit" class="btn btn-success">Enregistrer</button>
  <button type="reset" class="btn btn-secondary">Réinitialiser</button>
      </div>
    </form>
  </div>
</div>

        </div>
      </div>
    </section>
@endsection
