@extends('layouts.app')

@section('title', 'Partenaire')

@section('content')
<div class="card">
  <div class="card-body">
    <h5 class="card-title">Modifier le Partenaire</h5>

    <form method="POST" action="{{ route('partenaires.update', $partenaire->id) }}">
      @csrf
      @method('POST')

     <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">Code</label>
          <input type="text" name="code" value="{{ old('code', $partenaire->code) }}" class="form-control" required>
        </div>

        <div class="col-md-8">
          <label class="form-label">Nom</label>
          <input type="text" name="nom" value="{{ old('nom', $partenaire->nom) }}" class="form-control" required>
        </div>

        <div class="col-md-6">
          <label class="form-label">Type de partenaire</label>
          <select name="typepartenaire_id" class="form-select" required>
            @foreach($types as $t)
              <option value="{{ $t->id }}" {{ $partenaire->typepartenaire_id == $t->id ? 'selected' : '' }}>
                {{ $t->type }}
              </option>
            @endforeach
          </select>
        </div>

        <div class="col-12">
          <label class="form-label">Description</label>
          <textarea name="desctiption" class="form-control">{{ old('desctiption', $partenaire->desctiption) }}</textarea>
        </div>
      </div>

      <div class="mt-3">
        <button type="submit" class="btn btn-primary">Mettre à jour</button>
        <a href="{{ route('partenaires.index') }}" class="btn btn-secondary">Annuler</a>
      </div>
    </form>
  </div>
</div>
@endsection
