@extends('layouts.app')

@section('title', 'Programme')

@section('content')
 <div class="pagetitle">
      <h1>Modification d'un Programme</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="index.html">Acceuil</a></li>
          <li class="breadcrumb-item">Programme</li>
          <li class="breadcrumb-item active">Modification</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->
    <section class="section">
      <div class="row">
        <div class="col-lg-12">
<div class="card">
  <div class="card-body">
    <h5 class="card-title">Modifier le programme</h5>
    <form method="POST" action="{{ route('programmes.update', $programme->id) }}">
      @csrf
      @method('POST')
      <div class="row g-3">
        <div class="col-md-4">
          <label class="form-label">Code</label>
          <input type="text" name="code" class="form-control" value="{{ old('code', $programme->code) }}" required>
        </div>
        <div class="col-md-8">
          <label class="form-label">Nom</label>
          <input type="text" name="nom" class="form-control" value="{{ old('nom', $programme->nom) }}" required>
        </div>
        <div class="col-12">
          <label class="form-label">Description</label>
          <textarea name="description" class="form-control">{{ old('description', $programme->description) }}</textarea>
        </div>
        @php
    $usergroupId = Auth::user()->usergroup_id;
@endphp
@if($usergroupId != 3)
	<div class="text-center">
          <button type="submit" class="btn btn-primary">Mettre à jour</button>
          <a href="{{ route('programmes.index') }}" class="btn btn-secondary">Annuler</a>
        </div>
@endif
        
      </div>
    </form>
  </div>
</div>

        </div>
      </div>
    </section>
@endsection
 
