<?php $__env->startSection('title', 'Programmes'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h1>Programmes</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">Programmes</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <?php
                        $usergroupId = Auth::user()->usergroup_id;
						$user_rps = Auth::user()->responsableProgrammes->pluck('id')->toArray();
                    ?>

                    <?php if(in_array($usergroupId , [1, 2])): ?>
                        <h5 class="card-title">
                            <a href="<?php echo e(route('programmes.create')); ?>" class="btn btn-primary rounded-pill">
                                <i class="bi bi-plus-circle"></i> Ajouter
                            </a>
                        </h5>
                    <?php endif; ?>

                   
                 
                    	<?php if(isset($programmesrp)): ?>
  <h3 class="mb-4">Vos programmes</strong></h3>

                   <table id="example1" class="table table-custom">
                        <thead>
                            <tr>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Actif</th>
                                <th>Ouvert</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $programmesrp; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $programme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($programme->code); ?> : <?php echo e($programme->nom); ?></td>
                                    <td><?php echo e(Str::limit($programme->description, 30)); ?></td>

                                    <td>
                                        <?php if(in_array($usergroupId, [3,5,6])): ?>
                                            <button class="btn-sm-status <?php echo e($programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
                                                <?php echo e($programme->actif ? 'Oui' : 'Non'); ?>

                                            </button>
                                        <?php endif; ?>
                                        <?php if(in_array($usergroupId, [1,2,4])): ?>
                                            <a href="<?php echo e(route('programmes.fonctactif', $programme->id)); ?>" 
                                               class="btn-sm-status <?php echo e($programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>">
                                                <?php echo e($programme->actif ? 'Oui' : 'Non'); ?>

                                            </a>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php if(in_array($usergroupId, [3,5,6])): ?>
                                            <button class="btn-sm-status <?php echo e($programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
                                                <?php echo e($programme->ouvert ? 'Ouvert' : 'Fermé'); ?>

                                            </button>
                                        <?php endif; ?>
                                        <?php if(in_array($usergroupId, [1,2]) || ($usergroupId == 4 && in_array($programme->id, $user_rps))): ?>
                                            <a href="<?php echo e(route('programmes.fonctouvert', $programme->id)); ?>" 
                                               class="btn-sm-status <?php echo e($programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>">
                                                <?php echo e($programme->ouvert ? 'Ouvert' : 'Fermé'); ?>

                                            </a>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <a href="<?php echo e(route('programmes.show', $programme->id)); ?>" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>

                                        <?php if(in_array($usergroupId, [2])): ?> 
                                            <a href="<?php echo e(route('programmes.edit', $programme->id)); ?>" class="btn-sm-status btn-sm-status-warning">
                                                <i class="bi bi-pen"></i>
                                            </a>
                                            <a href="<?php echo e(route('programmes.destroy', $programme->id)); ?>" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer ce programme ?')">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    </br>  </br>  </br>
<?php endif; ?>
                    <!-- End Table -->
                      
                    <h3 class="mb-4">Programmes</strong></h3>
                      <button onclick="exportTableToExcel('example1', 'programmes.xlsx', {includeColumns: [0,1,2,3]})" 
        class="btn btn-success">
    Exporter en Excel
</button>
                   <table id="example1" class="table table-custom">
                        <thead>
                            <tr>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Actif</th>
                                <th>Ouvert</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $programmes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $programme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($programme->code); ?> : <?php echo e($programme->nom); ?></td>
                                    <td><?php echo e(Str::limit($programme->description, 30)); ?></td>

                                    <td>
                                        <?php if(in_array($usergroupId, [3,5,6,4])): ?>
                                            <button class="btn-sm-status <?php echo e($programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
                                                <?php echo e($programme->actif ? 'Oui' : 'Non'); ?>

                                            </button>
                                        <?php endif; ?>
                                        <?php if(in_array($usergroupId, [1,2])): ?>
                                            <a href="<?php echo e(route('programmes.fonctactif', $programme->id)); ?>" 
                                               class="btn-sm-status <?php echo e($programme->actif ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>">
                                                <?php echo e($programme->actif ? 'Oui' : 'Non'); ?>

                                            </a>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php if(in_array($usergroupId, [3,5,6,4])): ?>
                                            <button class="btn-sm-status <?php echo e($programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>" disabled>
                                                <?php echo e($programme->ouvert ? 'Ouvert' : 'Fermé'); ?>

                                            </button>
                                        <?php endif; ?>
                                        <?php if(in_array($usergroupId, [1,2])): ?>
                                            <a href="<?php echo e(route('programmes.fonctouvert', $programme->id)); ?>" 
                                               class="btn-sm-status <?php echo e($programme->ouvert ? 'btn-sm-status-success' : 'btn-sm-status-secondary'); ?>">
                                                <?php echo e($programme->ouvert ? 'Ouvert' : 'Fermé'); ?>

                                            </a>
                                        <?php endif; ?>
                                    </td>

                                    <td>
                 
                                        <?php if(in_array($usergroupId, [1,2])): ?>
                                                                 <a href="<?php echo e(route('programmes.show', $programme->id)); ?>" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>
                                        <?php endif; ?>
                                        <?php if(in_array($usergroupId, [3,5,6,4])): ?>
                                                                 <a href="<?php echo e(route('programmes.showrp', $programme->id)); ?>" class="btn-sm-status btn-sm-status-info"><i class="bi bi-eye"></i></a>
                                        <?php endif; ?>

                                        <?php if(in_array($usergroupId, [2])): ?> 
                                            <a href="<?php echo e(route('programmes.edit', $programme->id)); ?>" class="btn-sm-status btn-sm-status-warning">
                                                <i class="bi bi-pen"></i>
                                            </a>
                                            <a href="<?php echo e(route('programmes.destroy', $programme->id)); ?>" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer ce programme ?')">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>

        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/programmes/index.blade.php ENDPATH**/ ?>