

<?php $__env->startSection('title', 'Évaluation Activité'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
    <h1>Détails Activité</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.html">Accueil</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(route('activites.show', $activite->id)); ?>">Détails Activité</a></li>
            <li class="breadcrumb-item active">Évaluation</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">
            <div class="card shadow-sm border-0">
                <div class="card-body">
                    <h5 class="card-title">Détails de l'activité</h5>

                    
                    <?php if(session('status')): ?>
                        <div class="alert alert-success text-center"><?php echo e(session('status')); ?></div>
                    <?php endif; ?>
 <?php
                        $usergroupId = Auth::user()->usergroup_id;
                    ?>
                    
                    <h2>Détails : <strong><?php echo e($activite->nom); ?></strong></h2>
                    <hr>

                    <div class="callout callout-primary p-3 rounded shadow-sm bg-light">
                        <h5><b><u>Informations générales</u></b></h5>
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between"><b>Code :</b> <span><?php echo e($activite->code); ?></span></li>
                            <li class="list-group-item d-flex justify-content-between"><b>Nom :</b> <span><?php echo e($activite->nom); ?></span></li>
                            <li class="list-group-item d-flex justify-content-between"><b>Description :</b> <span><?php echo e($activite->description ?? '-'); ?></span></li>
                            <li class="list-group-item d-flex justify-content-between"><b>Montant :</b> <span><?php echo e($activite->montant ?? '-'); ?></span></li>
                            <li class="list-group-item d-flex justify-content-between"><b>Date Début :</b> <span><?php echo e($activite->datedebut); ?></span></li>
                            <li class="list-group-item d-flex justify-content-between"><b>Date Fin :</b> <span><?php echo e($activite->datefin ?? 'En cours'); ?></span></li>
                            <li class="list-group-item">
                                <b>État :</b>
                                <span class="fw-bold text-<?php echo e($activite->valide ? 'success' : 'danger'); ?>"><?php echo e($activite->valide ? 'Validée' : 'Non validée'); ?></span> |
                                <span class="fw-bold text-<?php echo e($activite->actif ? 'success' : 'danger'); ?>"><?php echo e($activite->actif ? 'Activée' : 'Non activée'); ?></span> |
                                <span class="fw-bold text-<?php echo e($activite->ouvert ? 'success' : 'primary'); ?>"><?php echo e($activite->ouvert ? 'Révision/Élaboration' : 'Suivi/Évaluation'); ?></span>
                            </li>
                        </ul>
                    </div>

                    <hr>

                    
                    <div class="callout callout-primary p-3 rounded shadow-sm bg-light">
                        <h5><b><u>Nouvelle évaluation</u></b></h5>
                        <table class="table table-bordered table-hover" id="evaluationTable">
                            <thead class="table-light">
                                <tr>
                                    <th>Extrant</th>
                                    <th>Date de référence</th>
                                    <th>Prévision</th>
                                    <th>Réalisation</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $grouped = $evalwaitings->groupBy('extrant_id'); ?>
                                <?php $__currentLoopData = $grouped; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extrantId => $items): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="table-primary">
                                        <td colspan="5"><strong>Extrant : <?php echo e($items->first()->extrant->nom ?? '-'); ?></strong></td>
                                    </tr>
                                    <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $toeval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr data-prevision-id="<?php echo e($toeval->id); ?>" data-activite-id="<?php echo e($activite->id); ?>">
                                            <td class="extrant-nom">
                                                <?php echo e($toeval->extrant->nom ?? '-'); ?>

                                                <input type="hidden" class="extrant-id" value="<?php echo e($toeval->extrant->id ?? ''); ?>">
                                            </td>
                                            <td class="date-reference"><?php echo e($toeval->dateevaluation); ?></td>
                                            <td class="taux-prevision"><?php echo e($toeval->niveaucible); ?></td>
                                            <td>
                                                <select class="form-control etape-select" disabled>
                                                    <option value="">-- Choisir une étape --</option>
                                                    <?php $__currentLoopData = $etapesParExtrant[$toeval->extrant->id] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $etape): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($etape->id); ?>" data-taux="<?php echo e($etape->niveauexec); ?>">
                                                            <?php echo e($etape->nom); ?> (<?php echo e($etape->niveauexec); ?>%)
                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($activite->over_taux): ?>
                                                        <option value="plus100" data-taux="100">Plus de 100%</option>
                                                    <?php endif; ?>
                                                </select>
                                            </td>
                                            <td>
                                                <?php $canEvaluate = ($evalwaitings->isNotEmpty() && $activite->valide && $activite->actif && !$activite->ouvert); ?>
                                                <?php if($canEvaluate): ?>
                                                    <button class="btn btn-warning btn-sm eval-btn">À Évaluer</button>
                                                    <button class="btn btn-success btn-sm ok-btn d-none">OK</button>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                    <hr>

                    
                    <div class="callout callout-primary p-3 rounded shadow-sm bg-light">
                        <h5><b><u>Anciennes évaluations</u></b></h5>
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Extrant</th>
                                    <th>Date de référence</th>
                                    <th>Date d'évaluation</th>
                                    <th>Prévision</th>
                                    <th>Réalisation</th>
                                    <th>Validé</th>
                                    <th></th>
                                    <th>Commentaire</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $groupedOld = $activite->evaluations->groupBy('extrant_id'); ?>
                                <?php $__currentLoopData = $groupedOld; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extrantId => $evaluations): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr class="table-primary">
                                        <td colspan="8"><strong>Extrant : <?php echo e($evaluations->first()->extrant->nom ?? '-'); ?></strong></td>
                                    </tr>
                                    <?php $__currentLoopData = $evaluations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($eval->extrant->nom ?? '-'); ?></td>
                                            <td><?php echo e($eval->prevision->dateevaluation ?? '-'); ?></td>
                                            <td><?php echo e($eval->date_evaluation ?? '-'); ?></td>
                                            <td><?php echo e($eval->prevision->niveaucible ?? '-'); ?> %</td>
                                            <td><?php echo e($eval->taux_realisation ?? '-'); ?> %</td>
                                            <td>
                                                <?php if($eval->valide): ?>
                                                    <button class="btn btn-sm <?php echo e($activite->valide ? 'btn-success' : 'btn-secondary'); ?>" disabled>OUI</button>
                                                <?php else: ?>
                                                    <a href="<?php echo e(route('evaluations.valider', $eval->id)); ?>" class="btn btn-sm btn-secondary">NON</a>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                            <?php if(in_array($usergroupId, [1,2])): ?>
                                                <?php if(!$eval->valide && $loop->last): ?>
                                                    <a href="<?php echo e(route('evaluations.edit', $eval->id)); ?>" class="btn btn-warning"><i class="bi bi-pen"></i></a>
                                                    <a href="<?php echo e(route('evaluations.destroy', $eval->id)); ?>" class="btn btn-danger" onclick="return confirm('Supprimer ?')"><i class="bi bi-trash"></i></a>
                                                <?php endif; ?>
                                             <?php endif; ?>
                                            </td>
                                            <td><?php echo e($eval->commentaire ?? '-'); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const log = msg => console.log("%c[DEBUG ÉVAL] " + msg, "color: #0a58ca");

    // --- Bouton "À Évaluer"
    document.querySelectorAll('.eval-btn').forEach(btn => {
        btn.addEventListener('click', () => {
            const row = btn.closest('tr');
            row.querySelector('.etape-select').disabled = false;
            row.querySelector('.ok-btn').classList.remove('d-none');
            btn.classList.add('d-none');
            log("Mode évaluation activé.");
        });
    });

    // --- Ajout dynamique du champ pondération si "Plus de 100%" est choisi
    document.querySelectorAll('.etape-select').forEach(select => {
        select.addEventListener('change', function () {
            const row = this.closest('tr');

            // Supprimer ancienne pondération/niveau si existant
            row.querySelectorAll('.pond-container, .niveau-container').forEach(el => el.remove());

            if(this.value === "plus100") {
                // Champ pondération
                const divPond = document.createElement('div');
                divPond.classList.add('pond-container', 'mt-2');
                divPond.innerHTML = '<label><b>Pondération supplémentaire (%) :</b></label>' +
                                     '<input type="number" min="1" class="form-control pond-value" placeholder="Ex : 10 pour obtenir 110%">';
                row.querySelector('td:nth-child(3)').appendChild(divPond);

                // Champ niveau total (lecture seule)
                const divNiveau = document.createElement('div');
                divNiveau.classList.add('niveau-container', 'mt-2');
                divNiveau.innerHTML = '<label><b>Niveau d\'exécution total (%) :</b></label>' +
                                      '<input type="number" class="form-control niveau-value" value="100" readonly>';
                row.querySelector('td:nth-child(3)').appendChild(divNiveau);

                // Mettre à jour en fonction de la pondération
                divPond.querySelector('.pond-value').addEventListener('input', e => {
                    const val = parseFloat(e.target.value);
                    divNiveau.querySelector('.niveau-value').value = 100 + (isNaN(val) ? 0 : val);
                });
            }
        });
    });

    // --- Bouton "OK"
    document.querySelectorAll('.ok-btn').forEach(btn => {
        btn.addEventListener('click', () => {
            const row = btn.closest('tr');
            const extrantId = row.querySelector('.extrant-id').value;
            const activiteId = row.dataset.activiteId;
            const previsionId = row.dataset.previsionId;
            const select = row.querySelector('.etape-select');
            const etapeId = select.value;

            if(!etapeId) return alert("Veuillez choisir une étape avant d'enregistrer.");

            let tauxRealisation = parseFloat(select.options[select.selectedIndex]?.dataset.taux) || 0;
            let finalEtapeId = etapeId;

            if(etapeId === "plus100") {
                const pond = parseFloat(row.querySelector('.pond-value')?.value);
                if(!pond || pond <= 0) return alert("Veuillez saisir une pondération valide (>0).");
                tauxRealisation = 100 + pond;
                finalEtapeId = null;
            }

            const tauxPrevision = parseFloat(row.querySelector('.taux-prevision').innerText.replace('%','').trim());
            const dateReference = row.querySelector('.date-reference').innerText.trim();

            const url = "<?php echo e(route('evaluations.store', ['activiteid' => 'ID'])); ?>".replace('ID', activiteId);

            fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type':'application/json',
                    'Accept':'application/json',
                    'X-CSRF-TOKEN':'<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify({
                    activite_id: activiteId,
                    previsionactivite_id: previsionId,
                    etape_id: finalEtapeId,
                    taux_realisation: tauxRealisation,
                    taux_prevision: tauxPrevision,
                    date_reference: dateReference,
                    extrant_id: extrantId
                })
            })
            .then(r => r.ok ? r.json() : r.json().then(err => { throw err; }))
            .then(data => {
                if(!data.success) return alert("Erreur : " + (data.message || "Impossible d'enregistrer."));
                alert("✅ Évaluation enregistrée avec succès !");
                select.disabled = true;
                btn.classList.add('d-none');
                setTimeout(() => window.location.href = "<?php echo e(route('redirect.delayed', $activite->id)); ?>", 600);
            })
            .catch(err => {
                const msg = err.message || JSON.stringify(err.errors) || "Erreur inconnue";
                alert("❌ " + msg);
            });
        });
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/activites/evaluate.blade.php ENDPATH**/ ?>