
<?php $__env->startSection('title', 'Structure'); ?>

<?php $__env->startSection('content'); ?>

<div class="pagetitle">
    <h1>Détails de la structure</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(url('index.html')); ?>">Accueil</a></li>
            <li class="breadcrumb-item"><a href="<?php echo e(url('structures')); ?>">Structure</a></li>
            <li class="breadcrumb-item active">Détails</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="card shadow-sm">
        <div class="card-body">

            
            <h3 class="mb-4">Structure : <strong><?php echo e($structure->nom); ?></strong></h3>

            
            <?php if(Session::has('status')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(Session::get('status')); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>
			
			<?php
				$usergroupId = Auth::user()->usergroup_id;
			?>

			
			<div class="row justify-content-start mb-4">
				<div class="col-md-9"> 
					<div class="callout callout-primary p-3 border border-primary rounded">
						<h5 class="mb-3 text-primary"><u>Informations générales</u></h5>
						<ul class="list-group list-group-flush">
							<li class="list-group-item d-flex justify-content-between">
								<b>Code :</b> <span><?php echo e($structure->code); ?></span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Intitulé :</b> <span><?php echo e($structure->nom); ?></span>
							</li>
							<li class="list-group-item d-flex justify-content-between">
								<b>Détails :</b> <span><?php echo e($structure->description); ?></span>
							</li>

							
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Structure activée :</b>
								<span>
									<?php if(in_array($usergroupId, [1,2])): ?>
										<a href="<?php echo e(route('structures.fonctactif', $structure->id)); ?>" class="btn btn-sm <?php echo e($structure->actif ? 'btn-success' : 'btn-secondary'); ?>">
											<?php echo e($structure->actif ? 'OUI' : 'NON'); ?>

										</a>
									<?php else: ?>
										<button class="btn btn-sm <?php echo e($structure->actif ? 'btn-success' : 'btn-secondary'); ?>" disabled>
											<?php echo e($structure->actif ? 'OUI' : 'NON'); ?>

										</button>
									<?php endif; ?>
								</span>
							</li>

							
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Responsable structure (RS) :</b>
								<span>
									<?php if(in_array($usergroupId, [1,2])): ?>
										<?php if(isset($structure->responsable)): ?>
											<?php echo e($structure->responsable->name); ?> (<?php echo e($structure->responsable->email); ?>)
											<a href="<?php echo e(route('structures.rsremove', $structure->id)); ?>" onclick="return confirm('Enlever ce RS ?')" class="text-danger ms-2">X</a>
										<?php else: ?>
											Non désigné
											<a href="<?php echo e(route('users.rpcreate', ['level' => 'respstruct', 'id' => $structure->id])); ?>" class="btn btn-warning btn-sm ms-2">
												<i class="bi bi-plus-circle"></i> Choisir/Modifier RS
											</a>
										<?php endif; ?>
									<?php endif; ?>
								</span>
							</li>
							
							<li class="list-group-item d-flex justify-content-between align-items-center">
								<b>Point focal (PF) :</b>
								<span>
									<?php if(in_array($usergroupId, [1,2])): ?>
										<?php if(isset($structure->pointfocal)): ?>
											<?php echo e($structure->pointfocal->name); ?> (<?php echo e($structure->pointfocal->email); ?>)
											<a href="<?php echo e(route('structures.pfremove', $structure->id)); ?>" onclick="return confirm('Enlever ce PF ?')" class="text-danger ms-2">X</a>
										<?php else: ?>
											Non désigné
											<a href="<?php echo e(route('users.rpcreate', ['level' => 'ptfocal', 'id' => $structure->id])); ?>" class="btn btn-danger btn-sm ms-2">
												<i class="bi bi-plus-circle"></i> Choisir/Modifier PF
											</a>
										<?php endif; ?>
									<?php endif; ?>
								</span>
							</li>
						</ul>
					</div>
				</div>
			</div>

            
            <div class="callout callout-info p-3 border border-info rounded">
                <h5 class="mb-3 text-info"><u>Historique des RS</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-info text-center">
                        <tr>
                            <th>Responsable</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $structure->responsablearchives ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($resp->responsable); ?></td>
                            <td><?php echo e($resp->datedebut); ?></td>
                            <td><?php echo e($resp->datefin ?? 'En cours'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
			
            <div class="callout callout-info p-3 border border-info rounded">
                <h5 class="mb-3 text-info"><u>Historique des PFs</u></h5>
                <table class="table table-bordered table-striped">
                    <thead class="table-info text-center">
                        <tr>
                            <th>Point focal</th>
                            <th>Du</th>
                            <th>Au</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $structure->pointfocalarchives ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($pf->pointfocal); ?></td>
                            <td><?php echo e($pf->datedebut); ?></td>
                            <td><?php echo e($pf->datefin ?? 'En cours'); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/structures/show.blade.php ENDPATH**/ ?>