@extends('layouts.app')

@section('title', 'Evaluations')

@section('content')
<div class="pagetitle">
  <h3>Tableau des évaluations</h3>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Evaluations</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <!-- Table with stripped rows -->
		

			<table class="table datatable table-custom">
					<thead class="table-dark">
						<tr>
							<th>Activité</th>
							<th>Extrant</th>
							<th>Période</th>
							<th>Prévision</th>
							<th>Réalisation</th>
							<th>Écart</th>
							<th>Commentaire</th>
							<th>Validée</th>
						</tr>
					</thead>
					<tbody>
						@foreach($evaluations->groupBy('activite_id') as $activiteId => $activiteEvals)
							@php
								$activite = $activiteEvals->first()->activite;
								$extrantsGrouped = $activiteEvals->groupBy('extrant_id');
							@endphp
							@foreach($extrantsGrouped as $extrantId => $extrantEvals)
								@php
									$extrant = $extrantEvals->first()->extrant;
								@endphp
								@foreach($extrantEvals as $index => $eval)
									@php
										$tauxPrevision = $eval->taux_prevision ?? 0;
										$tauxRealisation = $eval->taux_realisation ?? 0;
										$eccart = $tauxRealisation - $tauxPrevision;
									@endphp
									<tr>
										{{-- Activité : seulement sur la première ligne du groupe --}}
										@if($loop->first && $loop->parent->first)
											<td rowspan="{{ $extrantsGrouped->sum(fn($grp) => $grp->count()) }}">
												{{ $activite->nom }}
												<a href="{{ route('activites.planning', $activite->id) }}" class="btn btn-info btn-sm">
													<i class="bi bi-eye"></i>
												</a>
											</td>
										@endif

										{{-- Extrant : seulement sur la première ligne de son groupe --}}
										@if($loop->first)
											<td rowspan="{{ $extrantEvals->count() }}">
												{{ $extrant->nom }}
											</td>
										@endif

										{{-- Évaluation --}}
										<td>{{ $eval->date_reference }}</td>
										<td>{{ $tauxPrevision }}%</td>
										<td>{{ $tauxRealisation }}%</td>
										<td>
											@if ($eccart >= 0)
												<span style="background-color: #b7eb8f; color: black; padding: 3px 6px; border-radius: 4px;">
													{{ $eccart }}%
												</span>
											@else
												<span style="background-color: #f8b5b5; color: black; padding: 3px 6px; border-radius: 4px;">
													{{ $eccart }}%
												</span>
											@endif
										</td>
										<td>{{ $eval->commentaire ?? '-' }}</td>
										<td>
											<span class="badge {{ $eval->valide ? 'bg-success' : 'bg-danger' }}">
												{{ $eval->valide ? 'Oui' : 'Non' }}
											</span>
										</td>
									</tr>
								@endforeach
							@endforeach
						@endforeach
					</tbody>
				</table>

          <!-- End Table -->

        </div>
      </div>

    </div>
  </div>
</section>
@endsection


