@extends('layouts.app')

@section('title', 'Événements')

@section('content')
<div class="pagetitle">
    <h1>Liste des événements</h1>
</div>

<section class="section">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Toutes les sessions et événements</h5>

           

            <table class="table datatable table-custom">
                <thead>
                    <tr>
                        <th>Utilisateur</th>
                        <th>Niveau</th>
                        <th>Détails</th>
                        <th>Date</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($evenements as $e)
                    <tr>
                        {{-- Utilisateur --}}
                        <td>
                            @if(Str::startsWith($e->details, 'Échec'))
                                -
                            @else
                                {{ $e->utilisateur->email ?? '-' }}
                            @endif
                        </td>

                        {{-- Niveau --}}
                        <td>
                            @switch($e->level)
                                @case(1)
                                    <span class="badge bg-info badge-custom">Info</span>
                                    @break
                                @case(2)
                                    <span class="badge bg-warning text-dark badge-custom">Avertissement</span>
                                    @break
                                @case(3)
                                    <span class="badge bg-danger badge-custom">Danger</span>
                                    @break
                                @default
                                    <span class="badge bg-secondary badge-custom">Inconnu</span>
                            @endswitch
                        </td>

                        {{-- Détails --}}
                        <td>{{ $e->details }}</td>

                        {{-- Date --}}
                        <td>{{ $e->created_at->format('d/m/Y H:i') }}</td>

                        <td></td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

        </div>
    </div>
</section>
@endsection
