@extends('layouts.app')

@section('title', 'Accueil')

@section('content')
<div class="pagetitle">
    <h1>Partenaires</h1>
    <nav>
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="">Accueil</a></li>
            <li class="breadcrumb-item active">Partenaires</li>
        </ol>
    </nav>
</div>

<section class="section">
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">
                        <a href="{{ route('partenaires.create') }}" class="btn btn-primary rounded-pill">
                            <i class="bi bi-plus-circle"></i> Ajouter
                        </a>
                    </h5>

                   

                      <table class="table datatable table-custom">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Nom</th>
                                <th>Description</th>
                                <th>Type partenaire</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($partenaires as $partenaire)
                                <tr>
                                    <td>{{ $partenaire->code }}</td>
                                    <td>{{ $partenaire->nom }}</td>
                                    <td>{{ $partenaire->desctiption ?? '-' }}</td>
                                    <td>{{ $partenaire->typepartenaire ? $partenaire->typepartenaire->type : 'Non défini' }}</td>
                                    <td>
                                        <a href="{{ route('partenaires.edit', $partenaire->id) }}" class="btn-sm-status btn-sm-status-info">
                                            <i class="bi bi-pen"></i>
                                        </a>
                                        <a href="{{ route('partenaires.destroy', $partenaire->id) }}" class="btn-sm-status btn-sm-status-danger" onclick="return confirm('Supprimer ce partenaire ?')">
                                            <i class="bi bi-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    <!-- End Table -->

                </div>
            </div>

        </div>
    </div>
</section>
@endsection
