@extends('layouts.app')

@section('title', 'Groupe Utilisateurs')

@section('content')
<div class="pagetitle">
  <h1>Structures</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Groupes d utilisateurs</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="{{ route('usergroups.create') }}" class="btn btn-primary rounded-pill">
              <i class="bi bi-plus-circle"></i> Ajouter
            </a>
          </h5>

         

         <table class="table datatable table-custom">
            <thead>
              <tr>
                <th>Nom</th>
                <th>Description</th>
                <th></th>
                <th></th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              @foreach($usergroups as $group)
              <tr>
                <td>{{ $group->nom }}</td>
                <td>{{ $group->description }}</td>
                <td></td>
                <td></td>
                <td>
                  <a href="{{ route('usergroups.edit', $group->id) }}" class="btn-sm-status btn-sm-status-warning">
                    <i class="bi bi-pen"></i>
                  </a>
                  <a href="{{ route('usergroups.destroy', $group->id) }}"
                     class="btn-sm-status btn-sm-status-danger"
                     onclick="return confirm('Supprimer ce groupe ?')">
                    <i class="bi bi-trash"></i>
                  </a>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>

        </div>
      </div>

    </div>
  </div>
</section>
@endsection
