@extends('layouts.app')

@section('title', 'Accueil')

@section('content')
<div class="pagetitle">
      <h1>Tableau de bord</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="">Acceuil</a></li>
          <li class="breadcrumb-item active">Tableau de bord</li>
        </ol>
      </nav>
    </div><!-- End Page Title -->

    <section class="section dashboard">
	  

      <div class="row">

        <!-- Left side columns -->
        <div class="col-lg-12">
          <div class="row">

           

        

          
 <div class="row">

    <!-- Structures en retard -->
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Structures ayant dépassé leur délai d’évaluation ( {{$nombreStructuresEnRetard}})</h5>
      <table class="table datatable">
    <thead>
        <tr>
            <th>Structure</th>
            <th>Activité</th>
            <th>Date limite (date_reference)</th>
            <th>Date réelle (date_evaluation)</th>
            <th>Retard (jours)</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($structuresEnRetard as $structure)
            @foreach ($structure->activites as $activite)
                @foreach ($activite->evaluations as $evaluation)
                    <tr>
                        <td>{{ $structure->nom }}</td>
                        <td>{{ $activite->nom ?? $activite->code }}</td>
                        <td>{{ \Carbon\Carbon::parse($evaluation->date_reference)->toDateString() }}</td>
                        <td>
                            @if ($evaluation->date_evaluation)
                                {{ \Carbon\Carbon::parse($evaluation->date_evaluation)->toDateString() }}
                            @else
                                <span class="text-danger">Non évalué</span>
                            @endif
                        </td>
                        <td>
                            @php
                                $ref = \Carbon\Carbon::parse($evaluation->date_reference);
                                $eval = $evaluation->date_evaluation
                                        ? \Carbon\Carbon::parse($evaluation->date_evaluation)
                                        : \Carbon\Carbon::today();
                                $jours = $eval->diffInDays($ref, false);
                            @endphp
                            {{ $jours }} j
                        </td>
                    </tr>
                @endforeach
            @endforeach
        @endforeach
    </tbody>
</table>

        </div>
      </div>
    </div>

    <!-- Top 10 meilleurs taux -->
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Top 10 des meilleurs taux d’exécution</h5>
    <table class="table datatable">
      <thead>
        <tr>
            <th>Structure</th>
            <th>Activité</th>
            <th>Taux Prévision (%)</th>
            <th>Taux Réalisation (%)</th>
            <th>Écart (%)</th>
        </tr>
    </thead>
    <tbody>
            @foreach($topStructures as $evaluation)
          

            <tr>
                <td>{{ $evaluation->structure }}</td>
                <td>{{ $evaluation->activite }}</td>
                <td>{{ number_format($evaluation->taux_prevision, 2) }}</td>
                <td>{{ number_format($evaluation->taux_realisation, 2) }}</td>
                <td>
                
                @if ($evaluation->ecart < 5) 
                   <span style="background-color:#d4edda !important; color:#155724 !important; display:inline-block !important;"
>
                   
													{{ number_format($evaluation->ecart, 2) }}%
												</span>
                 @elseif ($evaluation->ecart < 15) 
                     <span style="background-color:#a9dfbf !important; color:#155724 !important; display:inline-block !important;">
                     

													{{ number_format($evaluation->ecart, 2) }}%
												</span>
                 @else {
                     <span  style="background-color:#28a745 !important; color:#155724 !important; display:inline-block !important;">
                    
													{{ number_format($evaluation->ecart, 2) }}%
												</span>
                
           
                @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>

        </div>
      </div>
    </div>

   <!-- Top 10 faibles taux -->
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h5 class="card-title">Top 10 des taux les plus faibles</h5>
    <table class="table datatable">
      <thead>
        <tr>
            <th>Structure</th>
            <th>Activité</th>
            <th>Taux Prévision (%)</th>
            <th>Taux Réalisation (%)</th>
            <th>Écart (%)</th>
        </tr>
    </thead>
    <tbody>
            @foreach($lowStructures as $evaluation)
          

            <tr>
                <td>{{ $evaluation->structure }}</td>
                <td>{{ $evaluation->activite }}</td>
                <td>{{ number_format($evaluation->taux_prevision, 2) }}</td>
                <td>{{ number_format($evaluation->taux_realisation, 2) }}</td>
                <td>
                
                  @if ($evaluation->ecart > -5)
        <span style="background-color:#f8d7da !important; color:#721c24 !important; display:inline-block !important;">
            {{ number_format($evaluation->ecart, 2) }}%
        </span>
    @elseif ($evaluation->ecart > -15)
        <span style="background-color:#f1aeb5 !important; color:#721c24 !important; display:inline-block !important;">
            {{ number_format($evaluation->ecart, 2) }}%
        </span>
    @else
        <span style="background-color:#dc3545 !important; color:white !important; display:inline-block !important;">
            {{ number_format($evaluation->ecart, 2) }}%
        </span>
    @endif
                </td>
            </tr>
        @endforeach
    </tbody>
</table>

        </div>
      </div>
    </div>
<!-- Graphique -->
    <div class="col-lg-12">
    <div class="card">
        <div class="card-body">
            <h5 class="card-title">Taux moyens par programme</h5>
            <canvas id="tauxChart"></canvas>
        </div>
    </div>
</div>

  </div>
         
            <!-- Recent Sales -->
			
			
            
			
			
			

        

          </div>
        </div><!-- End Left side columns -->

    

      </div>
    </section>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
const ctx = document.getElementById('tauxChart');

new Chart(ctx, {
    type: 'line',
    data: {
        labels: {!! json_encode($tauxParProgramme->pluck('nom')) !!},
        datasets: [{
            label: 'Taux moyen (%)',
            data: {!! json_encode($tauxParProgramme->pluck('taux_moyen')) !!},
            borderWidth: 2,
            borderColor: 'rgba(54, 162, 235, 1)',
            backgroundColor: 'rgba(54, 162, 235, 0.3)',
            fill: true,
            tension: 0.4
        }]
    },
    options: {
        scales: {
            y: {
                beginAtZero: true,
                suggestedMax: 120
            }
        } 
    }
});
</script>
@endsection
