<?php $__env->startSection('title', 'Extrants'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Extrants</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Extrants</li>
    </ol>
  </nav>
</div><!-- End Page Title -->

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">

              <i class="bi bi-plus-circle"></i> Ajouter
            </a>
          </h5>

          <!-- Table with stripped rows -->
          <table class="table datatable">
            <thead>
              <tr>
                <th>Nom de l'Extrant</th>
                <th>Activités associées</th>
                <th>Taux d’exécution (%)</th>
                <th>Actions</th>
				 <th></th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $extrants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extrant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                  <td><?php echo e($extrant->nom); ?></td>
                  <td>
                    <?php if($extrant->activites && $extrant->activites->count() > 0): ?>
                      <ul class="mb-0">
                        <?php $__currentLoopData = $extrant->activites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li><?php echo e($activite->nom); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </ul>
                    <?php else: ?>
                      <span class="text-muted">Aucune activité</span>
                    <?php endif; ?>
                  </td>
                  <td>
                    <span class="badge bg-info text-dark">
                      <?php echo e(number_format($extrant->taux_execution, 2)); ?> %
                    </span>
                  </td>
                  <td>
                    <a href="<?php echo e(route('extrants.show', $extrant->id)); ?>" class="btn btn-info btn-sm">
                      <i class="bi bi-eye"></i>
                    </a>
                  </td>
				  <td>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
          <!-- End Table -->

        </div>
      </div>

    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/indicateurs/index.blade.php ENDPATH**/ ?>