<?php $__env->startSection('title', 'Structures'); ?>

<?php $__env->startSection('content'); ?>
<div class="pagetitle">
  <h1>Structures</h1>
  <nav>
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="">Accueil</a></li>
      <li class="breadcrumb-item active">Structures</li>
    </ol>
  </nav>
</div>

<section class="section">
  <div class="row">
    <div class="col-lg-12">

      <div class="card">
        <div class="card-body">
          <h5 class="card-title">
            <a href="<?php echo e(route('structures.create')); ?>" class="btn btn-primary rounded-pill">
              <i class="bi bi-plus-circle"></i> Ajouter
            </a>
          </h5>

        

          <table class="table datatable table-custom">
            <thead>
              <tr>
                <th>Code</th>
                <th>Nom</th>
                <th>Description</th>
                <th>Ministère</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              <?php $__currentLoopData = $structures; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $structure): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><?php echo e($structure->code); ?></td>
                <td><?php echo e($structure->nom); ?></td>
                <td><?php echo e($structure->description); ?></td>
                <td><?php echo e($structure->ministere ? $structure->ministere->nom : 'Non défini'); ?></td>
                <td>
                  <a href="<?php echo e(route('structures.edit', $structure->id)); ?>" class="btn-sm-status btn-sm-status-info">
                    <i class="bi bi-pen"></i>
                  </a>
                  <a href="<?php echo e(route('structures.destroy', $structure->id)); ?>" 
                     class="btn-sm-status btn-sm-status-danger"
                     onclick="return confirm('Supprimer cette structure ?')">
                    <i class="bi bi-trash"></i>
                  </a>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>

        </div>
      </div>

    </div>
  </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /var/www/html/phaso/resources/views/structures/index.blade.php ENDPATH**/ ?>