<?php

namespace App\Http\Controllers;

use App\Models\Resultat;
use App\Models\Action;
use Illuminate\Http\Request;

class ResultatsController extends Controller
{
    public function index() { 
		return Resultat::all(); 
	}
	
	public function create($actionid=null)
    {
		if(isset($actionid)){
			$action = Action::select('ouvert', 'actif')->findOrFail($actionid);
			if(!$action->ouvert){
				return redirect()->back()->with('error', 'Impossible d\'ajouter des activités à une action fermée');
			}
			if(!$action->actif){
				return redirect()->back()->with('error', 'Impossible, demandez l\'activation de l\'action');
			}
		}
		$action = Action::find($actionid);
		//dd($actionid); die();
        return view('resultats.create', compact('action'));
    }

    public function store(Request $request)
    {
        $data = $request->validate([
			'action_id' => 'required|exists:actions,id',
            'nom' => 'required',
			
        ]);
		//dd($request); die();
       /* Resultat::create($request->all());
		return redirect()->route('actions.show', $request->action_id)->with('success', 'Donnée ajoutée avec succès.');*/
     try {
          

            $resultat = Resultat::create($data);

            if ($resultat) {
                return redirect()->route('actions.show', $request->action_id)
                    ->with('success', 'Donnée ajoutée avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de l’ajout du résultat.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
    }

    /* public function update(Request $request, $id)
    {
        $res = Resultat::findOrFail($id);
        $data = $request->validate([
            'activite_id' => 'sometimes|integer',
            'indicateur_id' => 'sometimes|integer',
            'valeur' => 'sometimes|numeric',
        ]);
        $res->update($data);
        return $res;
    } */

    public function destroy($id) {
	/*	$action_id = Resultat::select('action_id')->findOrFail($id)->action_id;
		Resultat::findOrFail($id)->delete();
		return redirect()->route('actions.show', $action_id)->with('success', 'Donnée ajoutée avec succès.');*/
     try {
            $resultat = Resultat::findOrFail($id);
            $action_id = $resultat->action_id;

            if ($resultat->delete()) {
                return redirect()->route('actions.show', $action_id)
                    ->with('success', 'Donnée supprimée avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la suppression.');
            }
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur inattendue : ' . $e->getMessage());
        }
	}
}
