<?php

namespace App\Http\Controllers;

use App\Models\TypePartenaire;
use Illuminate\Http\Request;

class TypePartenairesController extends Controller
{
    public function index()
    {
        /*$typepartenaires = TypePartenaire::all();
        return view('typepartenaires.index', compact('typepartenaires'));*/
        try {
            $typepartenaires = TypePartenaire::all();
            return view('typepartenaires.index', compact('typepartenaires'));
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement des types de partenaires : ' . $e->getMessage());
        }
    }

    public function create()
    {
       // return view('typepartenaires.create');
       try {
            return view('typepartenaires.create');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire : ' . $e->getMessage());
        }
    }

    public function store(Request $request)
    {
        /*$validated = $request->validate([
            'type' => 'required|string|max:100|unique:typepartenaires,type',
            'description' => 'nullable|string',
        ]);

        TypePartenaire::create($validated);

        return redirect()->route('typepartenaires.index')->with('success', 'Type de partenaire ajouté avec succès.');*/
        
        $validated = $request->validate([
            'type' => 'required|string|max:100|unique:typepartenaires,type',
            'description' => 'nullable|string',
        ]);

        try {
            $typePartenaire = new TypePartenaire($validated);
            if ($typePartenaire->save()) {
                return redirect()->route('typepartenaires.index')->with('success', 'Type de partenaire ajouté avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de l’ajout du type de partenaire.');
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return redirect()->back()->withErrors($e->validator)->withInput();
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de l’ajout du type de partenaire : ' . $e->getMessage());
        }
    }

   public function edit($id = 0)
    {
	/*	$typepartenaire = TypePartenaire::find($id);
        return view('typepartenaires.edit', compact('typepartenaire'));*/
         try {
            $typepartenaire = TypePartenaire::findOrFail($id);
            return view('typepartenaires.edit', compact('typepartenaire'));
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('typepartenaires.index')->with('error', 'Type de partenaire introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors du chargement du formulaire d’édition : ' . $e->getMessage());
        }
    }
   public function update(Request $request, $id)
    {
	$typePartenaire = TypePartenaire::findOrFail($id);
        $validated = $request->validate([
            'type' => 'required|string|max:100|unique:typepartenaires,type,' . $typePartenaire->id,
            'description' => 'nullable|string',
        ]);

       /* $typePartenaire->update($validated);

        return redirect()->route('typepartenaires.index')->with('success', 'Type de partenaire mis à jour avec succès.');*/
        
         try {
          

            if ($typePartenaire->update($validated)) {
                return redirect()->route('typepartenaires.index')->with('success', 'Type de partenaire mis à jour avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la mise à jour du type de partenaire.');
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return redirect()->back()->withErrors($e->validator)->withInput();
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('typepartenaires.index')->with('error', 'Type de partenaire introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la mise à jour : ' . $e->getMessage());
        }
    }

    public function destroy($id)
    { /*$typePartenaire =TypePartenaire::findOrFail($id);

        $typePartenaire->delete();
        return redirect()->route('typepartenaires.index')->with('success', 'Type de partenaire supprimé avec succès.');*/
        
         try {
            $typePartenaire = TypePartenaire::findOrFail($id);
            if ($typePartenaire->delete()) {
                return redirect()->route('typepartenaires.index')->with('success', 'Type de partenaire supprimé avec succès.');
            } else {
                return redirect()->back()->with('error', 'Échec de la suppression du type de partenaire.');
            }
        } catch (\Illuminate\Database\Eloquent\ModelNotFoundException $e) {
            return redirect()->route('typepartenaires.index')->with('error', 'Type de partenaire introuvable.');
        } catch (\Exception $e) {
            return redirect()->back()->with('error', 'Erreur lors de la suppression : ' . $e->getMessage());
        }
    }
}
