<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckAdminAccess
{
    public function handle(Request $request, Closure $next)
    {
        $user = Auth::user();
		 if (!$user) {
            abort(403, 'Accès refusé : utilisateur non connecté.');
        }

        $groupId = $user->usergroup_id;

        // Si c’est le superadmin (id groupe = 2)
        if ($groupId == 2) {
            // Bloque l’accès à l’administration
            if (
               $request->is('usergroups*') ||
                ($request->is('users*') && !$request->routeIs('users.rpcreate')) ||
                $request->is('evenements*') ||
                $request->is('admin*')
            ) {
                abort(403, 'Accès interdit à la section Administration.');
            }
			return $next($request);
        }
		 if ($groupId == 3) {
            // Plein accès à l'administration et aux paramètres
            if ($request->is('admin*') || 
            $request->is('structures*') || 
            $request->is('ministeres*') || 
            $request->is('ministeres*') || 
            $request->is('csds*') || 
            $request->is('groupeactivitess*') || 
            $request->is('partenaires*') ||
             $request->is('usergroups*') ||
                $request->is('users*') ||
                $request->is('evenements*') 
            ) {
                return $next($request);
            }

            // Lecture seule pour le reste
            if (in_array($request->method(), ['GET', 'HEAD', 'OPTIONS'])) {
                return $next($request);
            }
            // Interdire les autres méthodes HTTP (POST, PUT, DELETE)
            abort(403, 'Lecture seule pour cet utilisateur.');
        }

        if ($groupId == 4) {
        
           if (
                $request->is('admin*') ||
                $request->is('structures*') ||
                $request->is('ministeres*') ||
                $request->is('csds*') ||
                $request->is('groupeactivites*') ||
                $request->is('partenaires*') ||
                $request->is('usergroups*') ||
                $request->is('users*') ||
                $request->is('evenements*') ||
                $request->is('indicateurs*')
            ) {
                abort(403, 'Accès interdit à la section Administration ou Paramètres.');
            }

            // Plein accès sur les actions et résultats de SON programme
            if ($request->is('actions*') || $request->is('resultats*')) {
                return $next($request);
            }

            // Lecture seule sur les activités de son programme
            if ($request->is('activites*')) {
                if (in_array($request->method(), ['GET', 'HEAD', 'OPTIONS'])) {
                    return $next($request);
                }
                abort(403, 'Vous ne pouvez pas modifier les activités.');
            }

            // Peut modifier son programme, mais pas l’activer, le désactiver, l’ouvrir ou le fermer
            if ($request->is('programmes*')) {
               
                
                 if (
                    $request->is('programmes/ajout') 
                ) {
                    abort(403, 'Seule la DGESS peut ajouter un programme.');
                }

                // Interdit de supprimer
                if ($request->isMethod('DELETE')) {
                    abort(403, 'Vous ne pouvez pas supprimer un programme.');
                }

                // Sinon modification autorisée
                return $next($request);
            }

            // Lecture seule sur tout le reste
            if (in_array($request->method(), ['GET', 'HEAD', 'OPTIONS'])) {
                return $next($request);
            }

            abort(403, 'Accès restreint pour votre profil Program Manager.');
        }
        if ($groupId == 5) { // structuremanager
    // Interdiction d'accéder à l'administration globale
    if (
        $request->is('admin*') ||
        $request->is('structures*') ||
        $request->is('ministeres*') ||
        $request->is('csds*') ||
        $request->is('groupeactivites*') ||
        $request->is('partenaires*') ||
        $request->is('usergroups*') ||
        $request->is('users*') ||
        $request->is('evenements*') ||
        $request->is('indicateurs*')
    ) {
        abort(403, 'Accès interdit à la section Administration.');
    }

    // Lecture seule sur les programmes, actions, activités, évaluations et structures
    if (
        $request->is('programmes*') ||
        $request->is('actions*') ||
        $request->is('activites*') ||
        $request->is('evaluations*') ||
        $request->is('evaluationstructures*') ||
        $request->is('responsablestructures*')
    ) {
        // Autoriser les requêtes de lecture
        if (in_array($request->method(), ['GET', 'HEAD', 'OPTIONS'])) {
            return $next($request);
        }

        // Exceptions : validation d’activité ou d’évaluation
        if (
            $request->is('activites/*/valide') ||
            $request->is('evaluations/*/valider')
        ) {
            return $next($request);
        }

        // Bloquer toute autre tentative de modification
        abort(403, 'Lecture seule pour ce profil Structure Manager.');
    }

    // Interdire toute autre route non prévue
    abort(403, 'Accès restreint pour votre profil Structure Manager.');
}

if ($groupId == 6) { // PointFocal
    // Accès lecture sur programmes, actions, activités
    if (
        $request->is('programmes*') ||
        $request->is('actions*') ||
        $request->is('activites*')
    ) {
        // Lecture seule sur GET, HEAD, OPTIONS
        if (in_array($request->method(), ['GET', 'HEAD', 'OPTIONS'])) {
            return $next($request);
        }
    }

    // Ajout d'une activité si le programme/action/activité n'est pas fermé
    if ($request->is('activites/ajout/*')) {
        // Ici tu peux ajouter un check supplémentaire si tu veux vérifier si le programme ou l'action est ouvert
        return $next($request);
    }

    // Modification d'une activité tant qu'elle n'est pas validée et que programme/action n'est pas fermé
    if ($request->is('activites/update/*') || $request->is('activites/*/edit')) {
        // Vérifier statut de l'activité ou programme/action avant modification si nécessaire
        return $next($request);
    }

    // Evaluation d'une activité
    if ($request->is('activites/*/evaluate')) {
        return $next($request);
    }

    // Validation d'activité ou d'évaluation interdite (RS ou DGESS seulement)
    if ($request->is('activites/*/valide') || $request->is('evaluations/*/valider')) {
        abort(403, 'Seule la validation par le RS ou la DGESS est autorisée.');
    }

    // Tout le reste interdit
    abort(403, 'Accès restreint pour votre profil PointFocal.');
}

       


        return $next($request);

      
        
}
}

