<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TypePartenaire extends Model
{
    use HasFactory;

    protected $table = 'typepartenaires';
    protected $primaryKey = 'id';

    protected $fillable = [
        'type',
        'description',
        'created_at',
        'updated_at',
    ];

    public $timestamps = true;

    public function partenaires()
    {
        return $this->hasMany(Partenaire::class, 'typepartenaire_id', 'id');
    }
}
